/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.entity.Update;
import com.atlassian.jira.upgrade.LegacyImmediateUpgradeTask;
import com.atlassian.jira.user.ApplicationUserEntity;
import java.util.List;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_Build6041
extends LegacyImmediateUpgradeTask {
    private final EntityEngine entityEngine;

    public UpgradeTask_Build6041(EntityEngine entityEngine) {
        this.entityEngine = entityEngine;
    }

    @Override
    public int getBuildNumber() {
        return 6041;
    }

    @Override
    public String getShortDescription() {
        return "Store user properties under ApplicationUser entity for rename user.";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        Select.WhereContext<GenericValue> selectQuery = Select.from("ExternalEntity").whereEqual("type", "com.atlassian.jira.user.OfbizExternalEntityStore");
        List<GenericValue> externalEntityUsers = this.entityEngine.run(selectQuery).asList();
        for (GenericValue externalEntityUser : externalEntityUsers) {
            Long oldId = externalEntityUser.getLong("id");
            String username = externalEntityUser.getString("name");
            username = IdentifierUtils.toLowerCase((String)username);
            ApplicationUserEntity user = (ApplicationUserEntity)Select.from(Entity.APPLICATION_USER).whereEqual("lowerUserName", username).runWith(this.entityEngine).singleValue();
            if (user == null) continue;
            Long newId = user.getId();
            Update.into("OSPropertyEntry").set("entityName", Entity.APPLICATION_USER.getEntityName()).set("entityId", newId).whereEqual("entityName", "ExternalEntity").andEqual("entityId", oldId).execute(this.entityEngine);
        }
    }

    @Override
    @Nullable
    public Integer dependsUpon() {
        return 6040;
    }
}

