/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.renderer.HackyRendererType;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.upgrade.LegacyImmediateUpgradeTask;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.collect.MultiMap;
import com.atlassian.jira.util.collect.MultiMaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build571
extends LegacyImmediateUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build571.class);
    private final OfBizDelegator ofBizDelegator;
    private final CustomFieldManager customFieldManager;
    private final FieldLayoutManager fieldLayoutManager;
    private final MultiMap<String, Long, Set<Long>> customFieldIdToFieldLayoutItemId = MultiMaps.createSetMultiMap();
    private static final String FIELD_LAYOUT_ITEM = "FieldLayoutItem";
    private static final String FIELD_RENDERERTYPE = "renderertype";
    private static final String FIELD_FIELDIDENTIFIER = "fieldidentifier";
    private static final String MULTI_VERSION_CF_KEY = "com.atlassian.jira.plugin.system.customfieldtypes:multiversion";
    private static final String FIELD_ID = "id";

    public UpgradeTask_Build571(OfBizDelegator ofBizDelegator, CustomFieldManager customFieldManager, FieldLayoutManager fieldLayoutManager) {
        this.ofBizDelegator = ofBizDelegator;
        this.customFieldManager = customFieldManager;
        this.fieldLayoutManager = fieldLayoutManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        List fieldLayoutItemGVs = this.ofBizDelegator.findByCondition(FIELD_LAYOUT_ITEM, null, (Collection)CollectionBuilder.list((Object[])new String[]{FIELD_FIELDIDENTIFIER, FIELD_ID}));
        for (GenericValue fieldLayoutItemGV : fieldLayoutItemGVs) {
            String customFieldId = fieldLayoutItemGV.getString(FIELD_FIELDIDENTIFIER);
            if (!customFieldId.startsWith("customfield_")) continue;
            this.customFieldIdToFieldLayoutItemId.putSingle((Object)customFieldId, (Object)fieldLayoutItemGV.getLong(FIELD_ID));
        }
        ArrayList fieldLayoutItemIdsToUpdate = new ArrayList();
        for (Map.Entry entry : this.customFieldIdToFieldLayoutItemId.entrySet()) {
            String customFieldKey;
            CustomField customFieldObject = this.customFieldManager.getCustomFieldObject((String)entry.getKey());
            if (customFieldObject == null || !(customFieldKey = customFieldObject.getCustomFieldType().getKey()).equals(MULTI_VERSION_CF_KEY)) continue;
            fieldLayoutItemIdsToUpdate.addAll((Collection)entry.getValue());
        }
        try {
            log.info("Updating " + fieldLayoutItemIdsToUpdate.size() + " custom field field layout item(s) with autocomplete renderer default");
            this.ofBizDelegator.bulkUpdateByPrimaryKey(FIELD_LAYOUT_ITEM, MapBuilder.singletonMap((Object)FIELD_RENDERERTYPE, (Object)HackyRendererType.FROTHER_CONTROL.getKey()), fieldLayoutItemIdsToUpdate);
            log.info("Updating system fields field layout item(s) with autocomplete renderer default");
            this.ofBizDelegator.bulkUpdateByAnd(FIELD_LAYOUT_ITEM, MapBuilder.singletonMap((Object)FIELD_RENDERERTYPE, (Object)HackyRendererType.FROTHER_CONTROL.getKey()), MapBuilder.build((Object)FIELD_FIELDIDENTIFIER, (Object)"fixVersions"));
            this.ofBizDelegator.bulkUpdateByAnd(FIELD_LAYOUT_ITEM, MapBuilder.singletonMap((Object)FIELD_RENDERERTYPE, (Object)HackyRendererType.FROTHER_CONTROL.getKey()), MapBuilder.build((Object)FIELD_FIELDIDENTIFIER, (Object)"versions"));
            this.ofBizDelegator.bulkUpdateByAnd(FIELD_LAYOUT_ITEM, MapBuilder.singletonMap((Object)FIELD_RENDERERTYPE, (Object)HackyRendererType.FROTHER_CONTROL.getKey()), MapBuilder.build((Object)FIELD_FIELDIDENTIFIER, (Object)"components"));
        }
        finally {
            this.fieldLayoutManager.refresh();
        }
    }

    @Override
    public String getShortDescription() {
        return "Initialize versions & components field renderers to autocomplete renderer default";
    }

    @Override
    public int getBuildNumber() {
        return 571;
    }

    @Override
    @Nullable
    public Integer dependsUpon() {
        return 554;
    }
}

