/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.upgrade.LegacyImmediateUpgradeTask;
import org.apache.commons.lang.StringUtils;

public class UpgradeTask_Build509
extends LegacyImmediateUpgradeTask {
    private static final String NEW_COLOUR = "#3c78b5";
    private static final String OLD_COLOUR = "#003366";
    private final ApplicationProperties applicationProperties;

    public UpgradeTask_Build509(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        String linkColour = this.applicationProperties.getString("jira.lf.text.linkcolour");
        String activeLinkColour = this.applicationProperties.getString("jira.lf.text.activelinkcolour");
        String headingColour = this.applicationProperties.getString("jira.lf.text.headingcolour");
        if (StringUtils.isEmpty((String)linkColour) || OLD_COLOUR.equals(linkColour)) {
            this.applicationProperties.setString("jira.lf.text.linkcolour", NEW_COLOUR);
        }
        if (StringUtils.isEmpty((String)activeLinkColour) || OLD_COLOUR.equals(activeLinkColour)) {
            this.applicationProperties.setString("jira.lf.text.activelinkcolour", NEW_COLOUR);
        }
        if (StringUtils.isEmpty((String)headingColour) || OLD_COLOUR.equals(headingColour)) {
            this.applicationProperties.setString("jira.lf.text.headingcolour", NEW_COLOUR);
        }
    }

    @Override
    public String getShortDescription() {
        return "Upgrades link, active link and text color to new default of #3c78b5.";
    }

    @Override
    public int getBuildNumber() {
        return 509;
    }
}

