/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jira.upgrade.UpgradeProvider;
import com.atlassian.jira.util.JiraUtils;
import com.google.common.collect.Lists;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.ParseException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;

public class XmlFileUpgradeProvider
implements UpgradeProvider {
    private static final String UPGRADE_XML_TYPE = "upgrade";
    private final String upgradesXmlFilePath;

    public XmlFileUpgradeProvider() {
        this("upgrades.xml");
    }

    XmlFileUpgradeProvider(String upgradesXmlFilePath) {
        this.upgradesXmlFilePath = upgradesXmlFilePath;
    }

    @Override
    public <T> Collection<T> getUpgradeTasks() {
        Collection<String> taskNames = this.getTaskNames();
        return (Collection)taskNames.stream().map(this::loadUpgradeTaskComponent).collect(CollectorsUtil.toImmutableListWithCapacity((int)taskNames.size()));
    }

    private Collection<String> getTaskNames() {
        ArrayList taskNames = Lists.newArrayList();
        try (InputStream is = this.getFileInputStream();){
            Document doc = new Document(is);
            Element root = doc.getRoot();
            Elements actions = root.getElements(UPGRADE_XML_TYPE);
            while (actions.hasMoreElements()) {
                Element action = (Element)actions.nextElement();
                taskNames.add(action.getElement("class").getTextString());
            }
        }
        catch (ParseException | IOException e) {
            throw new RuntimeException("Error parsing tasks file '" + this.upgradesXmlFilePath + "'", e);
        }
        return taskNames;
    }

    private InputStream getFileInputStream() {
        return Optional.ofNullable(ClassLoaderUtils.getResourceAsStream((String)this.upgradesXmlFilePath, this.getClass())).orElseThrow(() -> new RuntimeException("Could not read upgrade file '" + this.upgradesXmlFilePath + "'"));
    }

    private <T> T loadUpgradeTaskComponent(String taskName) {
        try {
            return JiraUtils.loadComponent(taskName, this.getClass());
        }
        catch (ClassNotFoundException | RuntimeException e) {
            throw new RuntimeException("Failed to instantiate task: " + taskName, e);
        }
    }
}

