/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade;

import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.model.querydsl.QUpgradeHistory;
import com.atlassian.jira.model.querydsl.QUpgradeVersionHistory;
import com.atlassian.jira.model.querydsl.UpgradeVersionHistoryDTO;
import com.atlassian.jira.upgrade.BuildVersionRegistry;
import com.atlassian.jira.upgrade.UpgradeVersionHistoryItem;
import com.atlassian.jira.upgrade.UpgradeVersionHistoryItemImpl;
import com.atlassian.jira.upgrade.UpgradeVersionHistoryManager;
import com.google.common.collect.Lists;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeVersionHistoryManagerImpl
implements UpgradeVersionHistoryManager {
    private static final Logger log = LoggerFactory.getLogger(UpgradeVersionHistoryManagerImpl.class);
    private static final Pattern BUILD_NUMBER_PATTERN = Pattern.compile("\\d+$");
    private final BuildVersionRegistry buildVersionRegistry;
    private final QueryDslAccessor queryDslAccessor;

    public UpgradeVersionHistoryManagerImpl(BuildVersionRegistry buildVersionRegistry, QueryDslAccessor queryDslAccessor) {
        this.buildVersionRegistry = buildVersionRegistry;
        this.queryDslAccessor = queryDslAccessor;
    }

    @Override
    public List<UpgradeVersionHistoryItem> getAllUpgradeVersionHistory() {
        ArrayList upgradeHistory = Lists.newArrayList();
        String previousVersion = null;
        String previousBuildNumber = null;
        Optional<UpgradeVersionHistoryItem> latestUpgradeTaskWithNoBuildNumber = this.getLatestUpgradeTaskWithNoBuildNumber();
        if (latestUpgradeTaskWithNoBuildNumber.isPresent()) {
            upgradeHistory.add(latestUpgradeTaskWithNoBuildNumber.get());
            previousVersion = latestUpgradeTaskWithNoBuildNumber.get().getTargetVersion();
            previousBuildNumber = latestUpgradeTaskWithNoBuildNumber.get().getTargetBuildNumber();
        }
        List versionHistory = this.queryDslAccessor.executeQuery(connection -> ((SQLQuery)((SQLQuery)connection.newSqlQuery().select((Expression)QUpgradeVersionHistory.UPGRADE_VERSION_HISTORY).from((Expression)QUpgradeVersionHistory.UPGRADE_VERSION_HISTORY)).orderBy(QUpgradeVersionHistory.UPGRADE_VERSION_HISTORY.timeperformed.asc())).fetch());
        for (UpgradeVersionHistoryDTO upgradeVersionHistory : versionHistory) {
            upgradeHistory.add(new UpgradeVersionHistoryItemImpl(upgradeVersionHistory.getTimeperformed(), upgradeVersionHistory.getTargetbuild(), upgradeVersionHistory.getTargetversion(), previousBuildNumber, previousVersion));
            previousVersion = upgradeVersionHistory.getTargetversion();
            previousBuildNumber = upgradeVersionHistory.getTargetbuild();
        }
        Collections.sort(upgradeHistory, (o1, o2) -> {
            if (o1.getTimePerformed() != null && o2.getTimePerformed() != null) {
                return o2.getTimePerformed().compareTo(o1.getTimePerformed());
            }
            if (o1.getTimePerformed() == null) {
                return 1;
            }
            return -1;
        });
        return upgradeHistory;
    }

    @Override
    public void addUpgradeVersionHistory(int buildNumber, String version) {
        this.queryDslAccessor.execute(connection -> {
            boolean alreadyContainsBuild;
            boolean bl = alreadyContainsBuild = ((SQLQuery)((SQLQuery)connection.newSqlQuery().select((Expression)QUpgradeVersionHistory.UPGRADE_VERSION_HISTORY).from((Expression)QUpgradeVersionHistory.UPGRADE_VERSION_HISTORY)).where((Predicate)QUpgradeVersionHistory.UPGRADE_VERSION_HISTORY.targetbuild.eq((Object)String.valueOf(buildNumber)))).fetchCount() > 0L;
            if (alreadyContainsBuild) {
                log.debug("A record already exists for build number '{}' - skipping creation.", (Object)buildNumber);
                return;
            }
            Timestamp timePerformed = new Timestamp(System.currentTimeMillis());
            connection.insert(QUpgradeVersionHistory.UPGRADE_VERSION_HISTORY).set((Path)QUpgradeVersionHistory.UPGRADE_VERSION_HISTORY.timeperformed, timePerformed).set((Path)QUpgradeVersionHistory.UPGRADE_VERSION_HISTORY.targetversion, version).set((Path)QUpgradeVersionHistory.UPGRADE_VERSION_HISTORY.targetbuild, String.valueOf(buildNumber)).executeWithId();
        });
    }

    private Optional<UpgradeVersionHistoryItem> getLatestUpgradeTaskWithNoBuildNumber() {
        Optional latestUpgradeTaskWithNoTargetBuild = this.queryDslAccessor.executeQuery(connection -> ((SQLQuery)((SQLQuery)connection.newSqlQuery().select((Expression)QUpgradeHistory.UPGRADE_HISTORY.upgradeclass).from((Expression)QUpgradeHistory.UPGRADE_HISTORY)).where((Predicate)QUpgradeHistory.UPGRADE_HISTORY.targetbuild.isEmpty().or((Predicate)QUpgradeHistory.UPGRADE_HISTORY.targetbuild.isNull()))).fetch().stream().map(this::extractBuildNumberFromUpgradeClass).filter(Objects::nonNull).max(Integer::compare));
        if (latestUpgradeTaskWithNoTargetBuild.isPresent()) {
            Integer buildNumber = (Integer)latestUpgradeTaskWithNoTargetBuild.get();
            BuildVersionRegistry.BuildVersion targetVersion = this.buildVersionRegistry.getVersionForBuildNumber(buildNumber);
            return Optional.of(new UpgradeVersionHistoryItemImpl(null, Integer.toString(targetVersion.getBuildNumberAsInteger()), targetVersion.getVersion(), Integer.toString(buildNumber), null, true));
        }
        return Optional.empty();
    }

    private Integer extractBuildNumberFromUpgradeClass(@Nonnull String upgradeClassName) {
        Matcher matcher = BUILD_NUMBER_PATTERN.matcher(upgradeClassName);
        if (matcher.find()) {
            return Integer.valueOf(matcher.group(0));
        }
        return null;
    }
}

