/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.JiraDelayedUpgradeCompletedEvent;
import com.atlassian.jira.upgrade.IndexingUpgradeService;
import com.atlassian.jira.upgrade.UpgradeResult;
import com.atlassian.jira.upgrade.UpgradeService;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.Schedule;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeScheduler {
    public static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)UpgradeService.class.getName());
    public static final JobId JOB_ID = JobId.of((String)UpgradeService.class.getName());
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradeScheduler.class);
    private final IndexingUpgradeService indexingUpgradeService;
    private final SchedulerService schedulerService;
    private final EventPublisher eventPublisher;
    private final BuildUtilsInfo buildUtilsInfo;

    public UpgradeScheduler(IndexingUpgradeService indexingUpgradeService, SchedulerService schedulerService, EventPublisher eventPublisher, BuildUtilsInfo buildUtilsInfo) {
        this.indexingUpgradeService = indexingUpgradeService;
        this.schedulerService = schedulerService;
        this.eventPublisher = eventPublisher;
        this.buildUtilsInfo = buildUtilsInfo;
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, this::runUpgrades);
    }

    private JobRunnerResponse runUpgrades(JobRunnerRequest jobRunnerRequest) {
        LOGGER.info("Running schedules upgrades");
        UpgradeResult upgradeResult = this.indexingUpgradeService.runUpgrades();
        if (upgradeResult.successful()) {
            LOGGER.info("Schedules upgrades completed successfully");
            this.eventPublisher.publish((Object)new JiraDelayedUpgradeCompletedEvent(this.buildUtilsInfo.getCurrentBuildNumber()));
            return JobRunnerResponse.success();
        }
        LOGGER.info("Scheduled upgrades completed with an error");
        return JobRunnerResponse.failed((String)"An error occurred running the scheduled upgrade tasks");
    }

    public UpgradeResult scheduleUpgrades(int delayInMinutes) {
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withSchedule(Schedule.runOnce((Date)DateTime.now().plusMinutes(delayInMinutes).toDate()));
        try {
            LOGGER.info("Scheduling upgrades to run in {} minute(s)", (Object)delayInMinutes);
            this.schedulerService.scheduleJob(JOB_ID, jobConfig);
            return UpgradeResult.OK;
        }
        catch (SchedulerServiceException e) {
            LOGGER.error("Unable to schedule upgrades for future execution :" + (Object)((Object)e), (Throwable)e);
            return new UpgradeResult(this.createErrorMessages((Exception)((Object)e)));
        }
    }

    private Collection<String> createErrorMessages(Exception e) {
        return ImmutableList.of((Object)("Unable to schedule upgrade tasks for future execution: " + e.getMessage() + '\n' + ExceptionUtils.getStackTrace((Throwable)e)));
    }
}

