/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade;

import com.atlassian.jira.config.ReindexMessageManager;
import com.atlassian.jira.index.request.ReindexRequest;
import com.atlassian.jira.index.request.ReindexRequestManager;
import com.atlassian.jira.index.request.ReindexRequestType;
import com.atlassian.jira.index.request.ReindexStatus;
import java.util.EnumSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeIndexManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradeIndexManager.class);
    private final ReindexRequestManager reindexRequestManager;
    private final ReindexMessageManager reindexMessageManager;

    public UpgradeIndexManager(ReindexRequestManager reindexRequestManager, ReindexMessageManager reindexMessageManager) {
        this.reindexRequestManager = reindexRequestManager;
        this.reindexMessageManager = reindexMessageManager;
    }

    public boolean runReindexIfNeededAndAllowed(Set<ReindexRequestType> reindexRequestTypes) {
        boolean immediateReindexesRequested = this.reindexRequestManager.isReindexRequested(EnumSet.of(ReindexRequestType.IMMEDIATE));
        if (reindexRequestTypes.isEmpty()) {
            if (immediateReindexesRequested) {
                LOGGER.info("There is an immediate reindex request but a reindex is not being ran. Sending a message to the admin screen for admins to initiate a reindex");
                this.reindexMessageManager.pushRawMessage(null, "admin.upgrade.reindex.deferred");
                return true;
            }
            LOGGER.info("Reindexing is not allowed after this upgrade and there is no immediate reindex requests");
            return true;
        }
        boolean reindexesRequested = this.reindexRequestManager.isReindexRequested(reindexRequestTypes);
        if (reindexesRequested) {
            return this.executeReindex(reindexRequestTypes, immediateReindexesRequested);
        }
        LOGGER.info("There is no reindex requests of type {} so none will be run", reindexRequestTypes);
        return true;
    }

    private boolean executeReindex(Set<ReindexRequestType> reindexRequestTypes, boolean immediateReindexesRequested) {
        LOGGER.debug("Reindex all data if indexing is turned on.");
        if (immediateReindexesRequested && reindexRequestTypes.contains(ReindexRequestType.IMMEDIATE)) {
            return this.executeImmediateReindex(reindexRequestTypes);
        }
        return this.executeDelayedReindex(reindexRequestTypes);
    }

    private boolean executeImmediateReindex(Set<ReindexRequestType> reindexRequestTypes) {
        LOGGER.info("Requesting immediate reindex");
        Set reindexRequests = this.reindexRequestManager.processPendingRequests(true, reindexRequestTypes, false);
        for (ReindexRequest reindexRequest : reindexRequests) {
            if (reindexRequest.getStatus() != ReindexStatus.FAILED) continue;
            return false;
        }
        return true;
    }

    private boolean executeDelayedReindex(Set<ReindexRequestType> reindexRequestTypes) {
        this.reindexRequestManager.processPendingRequests(false, reindexRequestTypes, true);
        LOGGER.info("Delayed reindex has been requested.");
        return true;
    }
}

