/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.InitializingComponent;
import com.atlassian.jira.cluster.zdu.ClusterUpgradeStateManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.upgrade.api.UpgradeContext;
import com.atlassian.upgrade.core.UpgradeTaskManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginUpgradeService
implements InitializingComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginUpgradeService.class);
    private final UpgradeTaskManager upgradeTaskManager;
    private final ClusterLockService clusterLockService;
    private final PluginEventManager pluginEventManager;
    private final ApplicationProperties applicationProperties;
    private final ClusterUpgradeStateManager clusterUpgradeStateManager;

    public PluginUpgradeService(UpgradeTaskManager upgradeTaskManager, ClusterLockService clusterLockService, PluginEventManager pluginEventManager, ApplicationProperties applicationProperties, ClusterUpgradeStateManager clusterUpgradeStateManager) {
        this.upgradeTaskManager = upgradeTaskManager;
        this.clusterLockService = clusterLockService;
        this.pluginEventManager = pluginEventManager;
        this.applicationProperties = applicationProperties;
        this.clusterUpgradeStateManager = clusterUpgradeStateManager;
    }

    public void upgradePlugins() {
        ClusterLock lock = this.clusterLockService.getLockForName(PluginUpgradeService.class.getName());
        if (lock.tryLock()) {
            try {
                LOGGER.debug("Upgrading plugins");
                this.upgradeTaskManager.upgradePlugins(() -> UpgradeContext.UpgradeTrigger.UPGRADE);
            }
            finally {
                lock.unlock();
            }
        } else {
            LOGGER.warn("Plugin upgrades are being performed by other node");
        }
    }

    @EventListener
    public void onPluginInstall(PluginEnabledEvent event) {
        Plugin plugin = event.getPlugin();
        String pluginKey = plugin.getKey();
        if (this.clusterUpgradeStateManager.areDelayedUpgradesHandledByCluster()) {
            LOGGER.debug("Plugin not upgraded, waiting for ZDU to handle plugin upgrades.");
            return;
        }
        this.upgradePlugin(pluginKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradePlugin(String pluginKey) {
        String lockName = "plugin.upgrade." + pluginKey;
        ClusterLock lock = this.clusterLockService.getLockForName(lockName);
        if (lock.tryLock()) {
            try {
                LOGGER.debug("Upgrading " + pluginKey);
                this.upgradeTaskManager.upgradePlugin(this::getUpgradeTrigger, pluginKey);
            }
            finally {
                lock.unlock();
            }
        } else {
            LOGGER.warn("{} plugin upgrades are being performed by other node", (Object)pluginKey);
        }
    }

    private UpgradeContext.UpgradeTrigger getUpgradeTrigger() {
        if (this.isJiraSetup()) {
            return UpgradeContext.UpgradeTrigger.UPGRADE;
        }
        return UpgradeContext.UpgradeTrigger.PROVISIONING;
    }

    private boolean isJiraSetup() {
        return "true".equals(this.applicationProperties.getString("jira.setup"));
    }

    @Override
    public void afterInstantiation() throws Exception {
        this.pluginEventManager.register((Object)this);
    }
}

