/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade;

import com.atlassian.jira.index.request.ReindexRequestType;
import com.atlassian.jira.upgrade.ClusterLockingUpgradeService;
import com.atlassian.jira.upgrade.UpgradeResult;
import com.atlassian.upgrade.api.UpgradeContext;
import java.util.Set;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingUpgradeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingUpgradeService.class);
    private final ClusterLockingUpgradeService delegate;

    public LoggingUpgradeService(ClusterLockingUpgradeService delegate) {
        this.delegate = delegate;
    }

    public UpgradeResult runUpgradesWithLogging(Set<ReindexRequestType> reindexRequestTypes, UpgradeContext upgradeContext, String description) {
        return this.runWithTaskLogging(description, () -> this.delegate.runUpgrades(reindexRequestTypes, upgradeContext));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpgradeResult runWithTaskLogging(String description, Supplier<UpgradeResult> operation) {
        UpgradeResult upgradeResult;
        long startTime = System.currentTimeMillis();
        UpgradeResult upgradeResult2 = null;
        try {
            LOGGER.info("{} has started", (Object)description);
            upgradeResult = upgradeResult2 = operation.get();
        }
        catch (Throwable throwable) {
            long duration = System.currentTimeMillis() - startTime;
            boolean success = upgradeResult2 != null && upgradeResult2.successful();
            LOGGER.info("{} has finished {}successfully, and took {} milliseconds to process.", new Object[]{description, success ? "" : "un", duration});
            throw throwable;
        }
        long duration = System.currentTimeMillis() - startTime;
        boolean success = upgradeResult2 != null && upgradeResult2.successful();
        LOGGER.info("{} has finished {}successfully, and took {} milliseconds to process.", new Object[]{description, success ? "" : "un", duration});
        return upgradeResult;
    }

    public boolean areUpgradesRunning() {
        LOGGER.info("Checking to see if any upgrades are currently running");
        boolean upgradesRunning = this.delegate.areUpgradesRunning();
        LOGGER.info("{} Upgrade Tasks currently running", (Object)(upgradesRunning ? "" : "No"));
        return upgradesRunning;
    }
}

