/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.event.JiraDelayedUpgradeCompletedEvent;
import com.atlassian.jira.index.request.ReindexRequest;
import com.atlassian.jira.index.request.ReindexRequestManager;
import com.atlassian.jira.index.request.ReindexRequestType;
import com.atlassian.jira.index.request.ReindexStatus;
import com.atlassian.jira.issue.index.IssueIndexingParams;
import com.atlassian.jira.upgrade.UpgradeTask;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.util.collect.Sized;
import com.atlassian.jira.util.index.Contexts;
import com.atlassian.jira.util.index.IndexLifecycleManager;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DelayedUpgradeJobRunner
implements JobRunner {
    private static final Logger log = Logger.getLogger(DelayedUpgradeJobRunner.class);
    private static final String REINDEX_ALLOWED_PROPERTY = "upgrade.reindex.allowed";
    static final String ENTITY = "UpgradeHistory";
    private static final String ID = "id";
    private static final String FIELD_TARGETBUILD = "targetbuild";
    private static final String FIELD_UPGRADECLASS = "upgradeclass";
    private static final String FIELD_STATUS = "status";
    private static final String STATUS_PENDING = "pending";
    private static final String STATUS_COMPLETE = "complete";
    private final EntityEngine entityEngine;
    private final IndexLifecycleManager indexManager;
    private final ClusterLockService clusterLockService;
    private final ApplicationProperties applicationProperties;
    private final ReindexRequestManager reindexRequestManager;
    private final EventPublisher eventPublisher;
    private final int currentBuildNumber;

    public DelayedUpgradeJobRunner(EntityEngine entityEngine, IndexLifecycleManager indexManager, ClusterLockService clusterLockService, ApplicationProperties applicationProperties, ReindexRequestManager reindexRequestManager, int currentBuildNumber, EventPublisher eventPublisher) {
        this.entityEngine = entityEngine;
        this.indexManager = indexManager;
        this.clusterLockService = clusterLockService;
        this.applicationProperties = applicationProperties;
        this.reindexRequestManager = reindexRequestManager;
        this.currentBuildNumber = currentBuildNumber;
        this.eventPublisher = eventPublisher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        ClusterLock lock = this.clusterLockService.getLockForName(DelayedUpgradeJobRunner.class.getName());
        lock.lock();
        try {
            JobRunnerResponse jobRunnerResponse;
            ImmutableList allErrors;
            ImmutableList.Builder errors = new ImmutableList.Builder();
            List tasks = Select.from(ENTITY).runWith(this.entityEngine).asList();
            ArrayList sortedTasks = new ArrayList(tasks);
            Collections.sort(sortedTasks, new Comparator<GenericValue>(){

                @Override
                public int compare(GenericValue task1, GenericValue task2) {
                    String buildNo1 = task1.getString(DelayedUpgradeJobRunner.FIELD_TARGETBUILD);
                    buildNo1 = buildNo1 == null ? "0" : buildNo1;
                    String buildNo2 = task2.getString(DelayedUpgradeJobRunner.FIELD_TARGETBUILD);
                    buildNo2 = buildNo2 == null ? "0" : buildNo2;
                    return Integer.valueOf(buildNo1).compareTo(Integer.valueOf(buildNo2));
                }
            });
            for (GenericValue taskGv : sortedTasks) {
                try {
                    UpgradeTask task;
                    try {
                        task = (UpgradeTask)JiraUtils.loadComponent(taskGv.getString(FIELD_UPGRADECLASS), this.getClass());
                    }
                    catch (ClassNotFoundException e) {
                        log.debug((Object)String.format("Historical task %s has history but no longer exists.", taskGv.getString(FIELD_UPGRADECLASS)));
                        continue;
                    }
                    if (STATUS_COMPLETE.equals(taskGv.getString(FIELD_STATUS))) {
                        if (task.getBuildNumber() <= this.getJiraBuildNumber()) continue;
                        this.setJiraBuildNumber(task.getBuildNumber());
                        continue;
                    }
                    if (!STATUS_PENDING.equals(taskGv.getString(FIELD_STATUS))) continue;
                    if (task.getScheduleOption().equals((Object)UpgradeTask.ScheduleOption.BEFORE_JIRA_STARTED)) {
                        log.error((Object)String.format("Foreground upgrade task %s did not run before JIRA started", task.getBuildNumber()));
                        log.error((Object)"No more upgrades will be run until this is resolved.");
                        errors.add((Object)String.format("Foreground upgrade task %s did not run before JIRA started", task.getBuildNumber()));
                        break;
                    }
                    try {
                        log.info((Object)("Performing Upgrade Task: " + task.getShortDescription()));
                        task.doUpgrade(false);
                    }
                    catch (Exception e) {
                        log.error((Object)String.format("Upgrade task %s failed", task.getBuildNumber()), (Throwable)e);
                        errors.add((Object)String.format("Upgrade task %s failed. Error : %s", task.getBuildNumber(), e.getMessage()));
                        break;
                    }
                    taskGv.set(FIELD_STATUS, (Object)STATUS_COMPLETE);
                    taskGv.store();
                    log.info((Object)("Upgrade Task: '" + task.getShortDescription() + "' succeeded"));
                    this.setJiraBuildNumber(task.getBuildNumber());
                }
                catch (GenericEntityException e) {
                    log.error((Object)String.format("Failed to set status for upgrade task %s", taskGv.getString(FIELD_TARGETBUILD)), (Throwable)e);
                    errors.add((Object)String.format("Failed to set status for upgrade task %s. Error %s", taskGv.getString(FIELD_TARGETBUILD), e.getMessage()));
                }
            }
            if (this.isReindexAllowed(jobRunnerRequest)) {
                try {
                    this.reindex((ImmutableList.Builder<String>)errors);
                }
                catch (Exception e) {
                    log.error((Object)"Failed to reindex JIRA following upgrades.", (Throwable)e);
                    errors.add((Object)String.format("Failed to find class for upgrade task %s", e.getMessage()));
                }
            }
            if ((allErrors = errors.build()).isEmpty()) {
                this.setJiraBuildNumber(this.currentBuildNumber);
                this.eventPublisher.publish((Object)new JiraDelayedUpgradeCompletedEvent(Integer.toString(this.currentBuildNumber)));
                jobRunnerResponse = JobRunnerResponse.success();
                return jobRunnerResponse;
            }
            jobRunnerResponse = JobRunnerResponse.failed((String)allErrors.toString());
            return jobRunnerResponse;
        }
        finally {
            lock.unlock();
        }
    }

    private boolean isReindexAllowed(JobRunnerRequest jobRunnerRequest) {
        Boolean isReindexAllowed = (Boolean)jobRunnerRequest.getJobConfig().getParameters().get(REINDEX_ALLOWED_PROPERTY);
        return isReindexAllowed == null ? true : isReindexAllowed;
    }

    public void reindex(IssueIndexingParams indexesToReindex) throws Exception {
        this.indexManager.reIndexIssuesInBackground(Contexts.percentageLogger((Sized)this.indexManager, (Logger)log), indexesToReindex);
    }

    private int getJiraBuildNumber() {
        if (this.applicationProperties.getString("jira.version.patched") == null) {
            this.setJiraBuildNumber(0);
        }
        return Integer.parseInt(this.applicationProperties.getString("jira.version.patched"));
    }

    private void setJiraBuildNumber(int version) {
        log.info((Object)("Setting current build number to " + version));
        this.applicationProperties.setString("jira.version.patched", String.valueOf(version));
    }

    private static ClusterLockService getClusterLockService() {
        return (ClusterLockService)ComponentAccessor.getComponent(ClusterLockService.class);
    }

    public static boolean isUpgradeRunning() {
        ClusterLock lock = DelayedUpgradeJobRunner.getClusterLockService().getLockForName(DelayedUpgradeJobRunner.class.getName());
        if (lock.tryLock()) {
            lock.unlock();
            return false;
        }
        return true;
    }

    private void reindex(ImmutableList.Builder<String> errors) throws Exception {
        log.debug((Object)"Reindex all data if indexing is turned on.");
        Set reindexRequests = this.reindexRequestManager.processPendingRequests(true, EnumSet.allOf(ReindexRequestType.class), true);
        for (ReindexRequest reindexRequest : reindexRequests) {
            if (reindexRequest.getStatus() != ReindexStatus.FAILED) continue;
            log.error((Object)String.format("Reindex of %s failed", reindexRequest.getAffectedIndexes()));
            errors.add((Object)String.format("Reindex of %s failed", reindexRequest.getAffectedIndexes()));
            return;
        }
    }
}

