/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade;

import com.atlassian.jira.cluster.zdu.ClusterUpgradeStateManager;
import com.atlassian.jira.upgrade.DelayedUpgradeService;
import com.atlassian.jira.upgrade.IndexingUpgradeService;
import com.atlassian.jira.upgrade.UpgradeResult;
import com.atlassian.jira.upgrade.UpgradeService;
import com.atlassian.jira.upgrade.UpgradeTask;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.upgrade.spi.UpgradeTaskFactory;
import java.util.List;
import java.util.stream.Collectors;

public class DefaultUpgradeService
implements UpgradeService {
    private final IndexingUpgradeService indexingUpgradeService;
    private final DelayedUpgradeService delayedUpgradeService;
    private final UpgradeTaskFactory upgradeTaskFactory;
    private final BuildUtilsInfo buildUtilsInfo;
    private final ClusterUpgradeStateManager clusterUpgradeStateManager;

    public DefaultUpgradeService(IndexingUpgradeService indexingUpgradeService, DelayedUpgradeService delayedUpgradeService, UpgradeTaskFactory upgradeTaskFactory, BuildUtilsInfo buildUtilsInfo, ClusterUpgradeStateManager clusterUpgradeStateManager) {
        this.indexingUpgradeService = indexingUpgradeService;
        this.delayedUpgradeService = delayedUpgradeService;
        this.upgradeTaskFactory = upgradeTaskFactory;
        this.buildUtilsInfo = buildUtilsInfo;
        this.clusterUpgradeStateManager = clusterUpgradeStateManager;
    }

    @Override
    public UpgradeResult runUpgrades() {
        List pendingUpgradeTasks = this.upgradeTaskFactory.getAllUpgradeTasks().stream().filter(this::isPending).collect(Collectors.toList());
        boolean immediateUpgradeTasksPending = pendingUpgradeTasks.stream().anyMatch(this::isImmediate);
        if (immediateUpgradeTasksPending) {
            return this.indexingUpgradeService.runUpgrades();
        }
        if (!this.clusterUpgradeStateManager.areDelayedUpgradesHandledByCluster()) {
            return this.delayedUpgradeService.scheduleUpgrades();
        }
        return UpgradeResult.OK;
    }

    private boolean isPending(com.atlassian.upgrade.spi.UpgradeTask upgradeTask) {
        return upgradeTask.getBuildNumber() > this.buildUtilsInfo.getDatabaseBuildNumber();
    }

    private boolean isImmediate(com.atlassian.upgrade.spi.UpgradeTask upgradeTask) {
        if (UpgradeTask.class.isAssignableFrom(upgradeTask.getClass())) {
            return ((UpgradeTask)upgradeTask).getScheduleOption() == UpgradeTask.ScheduleOption.BEFORE_JIRA_STARTED;
        }
        return false;
    }

    @Override
    public boolean areUpgradesRunning() {
        return this.indexingUpgradeService.areUpgradesRunning();
    }
}

