/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.transaction;

import com.atlassian.jira.transaction.RunnablesQueue;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
class RunnablesQueueImpl
implements RunnablesQueue {
    final Queue<Runnable> runnableQueue = new ConcurrentLinkedQueue<Runnable>();

    RunnablesQueueImpl() {
    }

    @Override
    public void offer(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        this.runnableQueue.add(runnable);
    }

    @Override
    public void clear() {
        this.runnableQueue.clear();
    }

    @Override
    public void runAndClear() {
        Runnable runnable;
        while ((runnable = this.runnableQueue.poll()) != null) {
            this.runIt(runnable);
        }
    }

    private void runIt(Runnable codeToRun) {
        SafePluginPointAccess.to().runnable(codeToRun);
    }

    @VisibleForTesting
    Queue<Runnable> queue() {
        return this.runnableQueue;
    }
}

