/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.task;

import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.task.TaskContext;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskProgressIndicator;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;

class TaskDescriptorImpl<V extends Serializable>
implements TaskDescriptor<V> {
    private static final long serialVersionUID = 6656416609727582193L;
    private final TaskContext taskContext;
    private final Date submittedTime;
    private final Long taskId;
    private final String description;
    private final String userName;
    private final String progressURL;
    private final TaskProgressIndicator taskProgressIndicator;
    private AtomicLong startedTimestamp = new AtomicLong();
    private AtomicLong finishedTimestamp = new AtomicLong();
    private final boolean cancellable;
    private volatile boolean cancelled;
    private volatile V result;

    TaskDescriptorImpl(@Nonnull Long taskId, @Nonnull String description, @Nonnull TaskContext taskContext, String userName, TaskProgressIndicator taskProgressIndicator, boolean cancellable) {
        this.cancellable = cancellable;
        Assertions.notNull((String)"taskId", (Object)taskId);
        Assertions.notNull((String)"description", (Object)description);
        Assertions.notNull((String)"taskContext", (Object)taskContext);
        this.taskContext = taskContext;
        this.description = description;
        this.taskId = taskId;
        this.userName = userName;
        this.submittedTime = new Date();
        this.taskProgressIndicator = taskProgressIndicator;
        this.progressURL = taskContext.buildProgressURL(taskId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TaskDescriptorImpl(@Nonnull TaskDescriptorImpl<V> copiedTaskDescriptor) {
        Assertions.notNull((String)"copiedTaskDescriptor", copiedTaskDescriptor);
        TaskDescriptorImpl<V> taskDescriptorImpl = copiedTaskDescriptor;
        synchronized (taskDescriptorImpl) {
            this.taskContext = copiedTaskDescriptor.getTaskContext();
            this.description = copiedTaskDescriptor.getDescription();
            this.taskId = copiedTaskDescriptor.getTaskId();
            this.userName = copiedTaskDescriptor.getUserName();
            this.submittedTime = copiedTaskDescriptor.getSubmittedTimestamp();
            this.taskProgressIndicator = copiedTaskDescriptor.getTaskProgressIndicator();
            this.progressURL = copiedTaskDescriptor.getProgressURL();
            this.cancellable = copiedTaskDescriptor.isCancellable();
            this.cancelled = copiedTaskDescriptor.isCancelled();
            this.result = copiedTaskDescriptor.getResult();
            this.startedTimestamp.set(super.getStartedTimestampMillis());
            this.finishedTimestamp.set(super.finishedTimestampMillis());
        }
    }

    @Override
    @ClusterSafe(value="TaskDescriptors are only updated on their originating node")
    public synchronized long getElapsedRunTime() {
        if (this.startedTimestamp.get() == 0L) {
            return 0L;
        }
        if (this.finishedTimestamp.get() == 0L) {
            return System.currentTimeMillis() - this.startedTimestamp.get();
        }
        return this.finishedTimestamp.get() - this.startedTimestamp.get();
    }

    @Override
    public V getResult() {
        return this.result;
    }

    @Override
    public boolean isCancellable() {
        return this.cancellable;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    @Override
    @ClusterSafe(value="TaskDescriptors are only updated on their originating node")
    public synchronized boolean isStarted() {
        return this.startedTimestamp.get() != 0L;
    }

    @Override
    @ClusterSafe(value="TaskDescriptors are only updated on their originating node")
    public synchronized boolean isFinished() {
        return this.finishedTimestamp.get() != 0L;
    }

    @Override
    @ClusterSafe(value="TaskDescriptors are only updated on their originating node")
    public synchronized Date getFinishedTimestamp() {
        if (this.finishedTimestamp.get() != 0L) {
            return new Date(this.finishedTimestamp.get());
        }
        return null;
    }

    private long finishedTimestampMillis() {
        return this.finishedTimestamp.get();
    }

    @ClusterSafe(value="TaskDescriptors are only updated on their originating node")
    synchronized void setFinishedTimestamp() {
        if (this.startedTimestamp.get() == 0L) {
            throw new IllegalStateException("Task has not yet started.");
        }
        if (!this.finishedTimestamp.compareAndSet(0L, System.currentTimeMillis())) {
            throw new IllegalStateException("Task has already finished.");
        }
    }

    @Override
    @ClusterSafe(value="TaskDescriptors are only updated on their originating node")
    public synchronized Date getStartedTimestamp() {
        if (this.startedTimestamp.get() != 0L) {
            return new Date(this.startedTimestamp.get());
        }
        return null;
    }

    private long getStartedTimestampMillis() {
        return this.startedTimestamp.get();
    }

    @ClusterSafe(value="TaskDescriptors are only updated on their originating node")
    synchronized void setStartedTimestamp() {
        if (!this.startedTimestamp.compareAndSet(0L, System.currentTimeMillis())) {
            throw new IllegalStateException("Task has already started.");
        }
    }

    @Override
    public Date getSubmittedTimestamp() {
        return new Date(this.submittedTime.getTime());
    }

    @Override
    public Long getTaskId() {
        return this.taskId;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public TaskContext getTaskContext() {
        return this.taskContext;
    }

    @Override
    public TaskProgressIndicator getTaskProgressIndicator() {
        return this.taskProgressIndicator;
    }

    @Override
    public String getProgressURL() {
        return this.progressURL;
    }

    @Override
    public void setResult(V result) {
        this.result = result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("taskId", (Object)this.taskId).add("result", this.result).toString();
    }
}

