/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.startup.StartupCheck;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginState;
import com.atlassian.plugin.metadata.PluginMetadataManager;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemPluginsEnabledStartupCheck
implements StartupCheck {
    private static final String FAULT_DESC_TEXT = "The following plugins are required by JIRA, but have not been started:";
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemPluginsEnabledStartupCheck.class);
    private final AtomicReference<ImmutableList<PluginInfo>> disabledSystemPluginKeys = new AtomicReference<Object>(null);

    @Override
    public boolean isOk() {
        return this.disabledSystemPluginKeys().isEmpty();
    }

    @Override
    public String getName() {
        return "System Plugins Startup Check";
    }

    @Override
    public String getFaultDescription() {
        return String.format("The following plugins are required by JIRA, but have not been started: %s", StringUtils.join(this.disabledSystemPluginKeys(), (String)", "));
    }

    @Override
    public String getHTMLFaultDescription() {
        StringBuilder desc = new StringBuilder();
        desc.append("<p>The following plugins are required by JIRA, but have not been started:</p>");
        desc.append("<ul>");
        for (PluginInfo pluginInfo : this.disabledSystemPluginKeys()) {
            desc.append("<li>").append(StringEscapeUtils.escapeHtml((String)pluginInfo.toString())).append("</li>");
        }
        desc.append("</ul>");
        return desc.toString();
    }

    private ImmutableList<PluginInfo> disabledSystemPluginKeys() {
        ImmutableList<PluginInfo> disabledKeys = this.disabledSystemPluginKeys.get();
        if (disabledKeys == null) {
            ImmutableList<PluginInfo> newList = this.calculateDisabledSystemPlugins();
            boolean wasSet = this.disabledSystemPluginKeys.compareAndSet(null, newList);
            disabledKeys = wasSet ? newList : this.disabledSystemPluginKeys.get();
        }
        return disabledKeys;
    }

    protected ImmutableList<PluginInfo> calculateDisabledSystemPlugins() {
        PluginAccessor pluginAccessor = ComponentAccessor.getPluginAccessor();
        if (pluginAccessor == null) {
            throw new IllegalStateException("PluginAccessor is null");
        }
        PluginMetadataManager pluginMetadataManager = (PluginMetadataManager)ComponentAccessor.getComponent(PluginMetadataManager.class);
        if (pluginMetadataManager == null) {
            throw new IllegalStateException("PluginMetadataManager is null");
        }
        Collection allPlugins = pluginAccessor.getPlugins();
        LOGGER.trace("All plugins: {}", (Object)allPlugins);
        ImmutableList systemPlugins = ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)allPlugins, (Predicate)new SystemPluginPredicate(pluginMetadataManager)));
        LOGGER.trace("System plugins: {}", (Object)systemPlugins);
        ImmutableList disabledSystemPlugins = ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)systemPlugins, (Predicate)new PluginNotEnabledPredicate()));
        LOGGER.trace("Disabled system plugins: {}", (Object)disabledSystemPlugins);
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)disabledSystemPlugins, (Function)new ExtractPluginInfoFunction()));
    }

    static class PluginInfo {
        final String key;
        final String name;

        PluginInfo(String key, String name) {
            this.key = (String)Assertions.notNull((Object)key);
            this.name = (String)Assertions.notNull((Object)name);
        }

        public String toString() {
            return this.name + " (" + this.key + ")";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PluginInfo that = (PluginInfo)o;
            if (!this.key.equals(that.key)) {
                return false;
            }
            return this.name.equals(that.name);
        }

        public int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + this.name.hashCode();
            return result;
        }
    }

    private static class ExtractPluginInfoFunction
    implements Function<Plugin, PluginInfo> {
        private ExtractPluginInfoFunction() {
        }

        public PluginInfo apply(Plugin plugin) {
            return new PluginInfo(plugin.getKey(), plugin.getName());
        }
    }

    private class PluginNotEnabledPredicate
    implements Predicate<Plugin> {
        private PluginNotEnabledPredicate() {
        }

        public boolean apply(Plugin input) {
            return !PluginState.ENABLED.equals((Object)input.getPluginState());
        }
    }

    private static class SystemPluginPredicate
    implements Predicate<Plugin> {
        private final PluginMetadataManager pluginMetadataManager;

        public SystemPluginPredicate(PluginMetadataManager pluginMetadataManager) {
            this.pluginMetadataManager = pluginMetadataManager;
        }

        public boolean apply(Plugin plugin) {
            return !this.pluginMetadataManager.isOptional(plugin);
        }
    }
}

