/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.startup.JiraStartupChecklist;
import com.atlassian.jira.template.velocity.DefaultVelocityEngineFactory;
import com.atlassian.jira.template.velocity.VelocityEngineFactory;
import com.atlassian.jira.web.util.MetalResourcesManager;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

public class JiraStartupChecklistFilter
implements Filter {
    private static final String SUFFIX = "JiraLockedError";
    private static final String LOCKED_TEMPLATE_NAME = "templates/jira/appconsistency/jiralocked.vm";
    private static final String NOERRORS_TEMPLATE_NAME = "templates/jira/appconsistency/no-errors-detected.vm";
    private final VelocityEngineFactory velocityEngineFactory = new DefaultVelocityEngineFactory("velocity-static.properties");

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        String contextPath = httpServletRequest.getContextPath();
        if (JiraStartupChecklist.startupOK()) {
            if (httpServletRequest.getRequestURI().endsWith(SUFFIX)) {
                try {
                    ImmutableMap parameters = ImmutableMap.of((Object)"contextPath", (Object)contextPath, (Object)"resourcesHtml", (Object)MetalResourcesManager.getMetalResources(contextPath));
                    httpServletResponse.setContentType("text/html; charset=UTF-8");
                    this.velocityEngineFactory.getEngine().mergeTemplate(NOERRORS_TEMPLATE_NAME, "UTF-8", (Context)new VelocityContext((Map)parameters), (Writer)httpServletResponse.getWriter());
                }
                catch (Exception e) {
                    throw new ServletException("Exception occurred while rendering template 'templates/jira/appconsistency/no-errors-detected.vm'.", (Throwable)e);
                }
            } else {
                filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
        } else if (httpServletRequest.getRequestURI().endsWith(SUFFIX)) {
            ImmutableMap parameters = ImmutableMap.of((Object)"failedStartupCheck", (Object)JiraStartupChecklist.getFailedStartupCheck(), (Object)"contextPath", (Object)contextPath, (Object)"resourcesHtml", (Object)MetalResourcesManager.getMetalResources(contextPath));
            try {
                httpServletResponse.setContentType("text/html; charset=UTF-8");
                httpServletResponse.setStatus(503);
                this.velocityEngineFactory.getEngine().mergeTemplate(LOCKED_TEMPLATE_NAME, "UTF-8", (Context)new VelocityContext((Map)parameters), (Writer)httpServletResponse.getWriter());
            }
            catch (Exception e) {
                throw new ServletException("Exception occurred while rendering template 'templates/jira/appconsistency/jiralocked.vm'.", (Throwable)e);
            }
        } else {
            httpServletResponse.sendRedirect(contextPath + "/" + SUFFIX);
        }
    }
}

