/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.startup.BootstrappingStartupState;
import com.atlassian.jira.startup.JiraStartupState;
import com.atlassian.jira.startup.RunningStartupState;
import com.atlassian.jira.startup.StartupCheck;
import com.atlassian.jira.startup.StartupStateTemplate;
import com.atlassian.jira.startup.SystemPluginsEnabledStartupCheck;
import com.google.common.collect.ImmutableList;
import java.util.concurrent.atomic.AtomicReference;

public class DelayedStartupState
extends StartupStateTemplate
implements JiraStartupState {
    private static final ImmutableList<StartupCheck> STARTUP_CHECKS = ImmutableList.of((Object)new SystemPluginsEnabledStartupCheck());
    private final BootstrappingStartupState bootstrapping;
    private final AtomicReference<JiraStartupState> currentState;

    public DelayedStartupState(BootstrappingStartupState bootstrapping, AtomicReference<JiraStartupState> currentState) {
        this.bootstrapping = bootstrapping;
        this.currentState = currentState;
    }

    @Override
    public boolean isStartupChecksPassed() {
        return this.bootstrapping.isStartupChecksPassed() && super.isStartupChecksPassed();
    }

    @Override
    public void onPluginSystemStarted() throws IllegalStateException {
        this.currentState.set(new RunningStartupState(this.bootstrapping, this.currentState));
    }

    @Override
    public void onPluginSystemDelayed() throws IllegalStateException {
        throw new IllegalStateException("onPluginSystemDelayed() called twice");
    }

    @Override
    public StartupCheck getFailedStartupCheck() {
        StartupCheck failedDelayCheck = this.bootstrapping.getFailedStartupCheck();
        if (failedDelayCheck != null) {
            return failedDelayCheck;
        }
        return super.getFailedStartupCheck();
    }

    @Override
    public void setFailedStartupCheck(StartupCheck startupCheck) {
        this.bootstrapping.setFailedStartupCheck(startupCheck);
    }

    @Override
    public void onPluginSystemStopped() {
        this.currentState.set(new BootstrappingStartupState(this.currentState));
    }

    @Override
    public void onPluginSystemRestarted() {
        this.currentState.set(new RunningStartupState(this.bootstrapping, this.currentState));
    }

    @Override
    public void onJiraStopping() {
        this.bootstrapping.onJiraStopping();
    }

    @Override
    protected ImmutableList<StartupCheck> getStartupChecks() {
        return STARTUP_CHECKS;
    }
}

