/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.startup.InstantUpgradeManager;
import com.atlassian.jira.util.StopWatch;
import com.atlassian.jira.util.johnson.JohnsonProvider;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.MDC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultInstantUpgradeManager
implements InstantUpgradeManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultInstantUpgradeManager.class);
    private static final String LOG_KEY = "jira.launcher.start.instanceenabled.millis";
    private static HoldingCounters holdingCounters = new HoldingCounters();
    private final AtomicReference<StartupTask> taskReference = new AtomicReference();
    private final AtomicBoolean activated = new AtomicBoolean(false);
    private final CountDownLatch fullyStarted = new CountDownLatch(1);
    private final JiraProperties jiraProperties;

    public DefaultInstantUpgradeManager(JiraProperties jiraProperties) {
        this.jiraProperties = jiraProperties;
    }

    @Override
    public void doNowOrWhenInstanceBecomesActive(Runnable task, String description) {
        if (!this.isInstantUpgradeEnabled()) {
            this.runTask(new StartupTask(task, description));
        } else if (this.taskReference.compareAndSet(null, new StartupTask(task, description))) {
            log.info("Instant Upgrade in progress. Task [{}] registered. Awaiting instance to be activated", (Object)description);
        } else {
            throw new IllegalStateException("Instance Upgrade task has already been registered");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTask(StartupTask task) {
        try {
            log.info("Now running [{}]", (Object)task.getDescription());
            StopWatch stopWatch = new StopWatch();
            task.run();
            long elapsedTime = stopWatch.getTotalTime();
            MDC.put((String)LOG_KEY, (Object)elapsedTime);
            log.info("{} took {}s", (Object)task.getDescription(), (Object)(elapsedTime / 1000L));
            MDC.remove((String)LOG_KEY);
        }
        finally {
            this.fullyStarted.countDown();
        }
    }

    @Override
    public InstantUpgradeManager.State getState() {
        if (!this.isInstantUpgradeEnabled()) {
            return InstantUpgradeManager.State.DISABLED;
        }
        if (this.hasErrorOrFatalJohnsonEvents()) {
            return InstantUpgradeManager.State.ERROR;
        }
        if (this.fullyStarted.getCount() == 0L) {
            return InstantUpgradeManager.State.FULLY_STARTED;
        }
        if (this.taskReference.get() == null) {
            return InstantUpgradeManager.State.EARLY_STARTUP;
        }
        if (!this.activated.get()) {
            return InstantUpgradeManager.State.WAITING_FOR_ACTIVATION;
        }
        return InstantUpgradeManager.State.LATE_STARTUP;
    }

    @Override
    public ServiceResult activateInstance() {
        if (!this.isInstantUpgradeEnabled()) {
            return ServiceOutcomeImpl.error("Instance upgrade is NOT enabled, ignoring instance activation request.");
        }
        if (this.taskReference.get() == null) {
            return ServiceOutcomeImpl.error("Instance upgrade task was not set, ignoring instance activation request.");
        }
        if (!this.activated.compareAndSet(false, true)) {
            return ServiceOutcomeImpl.error("Instance is already activated, ignoring instance activation request.");
        }
        return this.runDelayedTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceOutcomeImpl runDelayedTask() {
        try {
            this.runTask(this.taskReference.get());
            ServiceOutcomeImpl<Object> serviceOutcomeImpl = ServiceOutcomeImpl.ok(null);
            return serviceOutcomeImpl;
        }
        catch (Exception e) {
            JohnsonProvider johnsonProvider = (JohnsonProvider)ComponentAccessor.getComponentOfType(JohnsonProvider.class);
            log.error("Unable to start JIRA.", (Throwable)e);
            String errorMessage = "Unexpected exception during JIRA startup. This JIRA instance will not be able to recover. Please check the logs for details.";
            johnsonProvider.getContainer().addEvent(new Event(EventType.get((String)"startup-unexpected"), errorMessage, EventLevel.get((String)"fatal")));
            ServiceOutcomeImpl serviceOutcomeImpl = ServiceOutcomeImpl.error(errorMessage);
            return serviceOutcomeImpl;
        }
        finally {
            DefaultInstantUpgradeManager.holdingCounters.logInformation();
        }
    }

    private boolean isInstantUpgradeEnabled() {
        return this.jiraProperties.getBoolean("instant.upgrade");
    }

    private boolean hasErrorOrFatalJohnsonEvents() {
        Collection events = ((JohnsonProvider)ComponentAccessor.getComponentOfType(JohnsonProvider.class)).getContainer().getEvents();
        boolean hasErrors = events.stream().anyMatch(event -> event.getLevel() != EventLevel.get((String)"warning"));
        if (hasErrors) {
            log.debug("Application state is ERROR");
        }
        return hasErrors;
    }

    @Override
    public boolean waitTillFullyStarted(long time, TimeUnit unit) throws InterruptedException {
        holdingCounters.incrementWaiting();
        boolean countReachedZero = this.fullyStarted.await(time, unit);
        if (!countReachedZero) {
            holdingCounters.timeOut();
        }
        return countReachedZero;
    }

    private static class HoldingCounters {
        private static final String NUMBER_HELD_REQUESTS = "jira.instant.holdingfilter.total.held";
        private static final String NUMBER_RELEASED_REQUESTS = "jira.instant.holdingfilter.total.released";
        private static final String NUMBER_TIMEDOUT_REQUESTS = "jira.instant.holdingfilter.total.timedout";
        private AtomicInteger timedOut = new AtomicInteger(0);
        private AtomicInteger allThreads = new AtomicInteger(0);

        private HoldingCounters() {
        }

        public void incrementWaiting() {
            this.allThreads.incrementAndGet();
        }

        public void timeOut() {
            this.timedOut.incrementAndGet();
        }

        private void logInformation() {
            long allHeldThreads = this.allThreads.get();
            long timedOutThreads = this.timedOut.get();
            long releasedThreads = allHeldThreads - timedOutThreads;
            MDC.put((String)NUMBER_HELD_REQUESTS, (Object)allHeldThreads);
            MDC.put((String)NUMBER_RELEASED_REQUESTS, (Object)releasedThreads);
            MDC.put((String)NUMBER_TIMEDOUT_REQUESTS, (Object)timedOutThreads);
            log.info("{} threads have been held. {} have been successfully released and {} have timed out", new Object[]{allHeldThreads, releasedThreads, timedOutThreads});
            MDC.remove((String)NUMBER_HELD_REQUESTS);
            MDC.remove((String)NUMBER_RELEASED_REQUESTS);
            MDC.remove((String)NUMBER_TIMEDOUT_REQUESTS);
        }
    }

    private static class StartupTask
    implements Runnable {
        private final Runnable runnable;
        private final String description;

        public StartupTask(Runnable runnable, String description) {
            this.runnable = runnable;
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        public void run() {
            this.runnable.run();
        }
    }
}

