/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.config.webwork.WebworkConfigurator;
import com.atlassian.jira.startup.FailedStartupCheck;
import com.atlassian.jira.startup.JiraLauncher;
import com.atlassian.jira.startup.JiraStartupChecklist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentContainerLauncher
implements JiraLauncher {
    private static final Logger log = LoggerFactory.getLogger(ComponentContainerLauncher.class);

    @Override
    public void start() {
        try {
            this.populateFullPicoContainer();
        }
        catch (RuntimeException rte) {
            log.error("A RuntimeException occurred during ComponentContainerLauncher servlet context initialisation - " + rte.getMessage() + ".", (Throwable)rte);
            throw rte;
        }
        catch (Error error) {
            log.error("An Error occurred during ComponentContainerLauncher servlet context initialisation - " + error.getMessage() + ".", (Throwable)error);
            throw error;
        }
    }

    private void populateFullPicoContainer() {
        if (JiraStartupChecklist.startupOK()) {
            try {
                ComponentManager componentManager = ComponentManager.getInstance();
                if (componentManager.getState().isContainerInitialised()) {
                    componentManager.shutdown();
                }
                componentManager.initialise();
                WebworkConfigurator.setupConfiguration();
            }
            catch (Exception ex) {
                log.error("A fatal error occurred during initialisation. JIRA has been locked.", (Throwable)ex);
                String message = ex.getMessage() == null ? ex.getClass().getSimpleName() : ex.getMessage();
                JiraStartupChecklist.setFailedStartupCheck(new FailedStartupCheck("Component Manager", message));
            }
        } else {
            log.error("Not initializing JIRA, the startup checklist failed and JIRA has been locked.");
        }
    }

    @Override
    public void stop() {
        ComponentManager.getInstance().dispose();
    }
}

