/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.ClusterServicesManager;
import com.atlassian.jira.cluster.monitoring.ClusterMonitoringBeansRegistrar;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.startup.JiraLauncher;
import com.google.common.annotations.VisibleForTesting;

public class ClusteringLauncher
implements JiraLauncher {
    private ClusterMonitoringBeansRegistrar clusterMonitoringBeansRegistrar;
    private boolean clusterMonitoringStarted = false;

    public ClusteringLauncher() {
        this(new ClusterMonitoringBeansRegistrar());
    }

    @VisibleForTesting
    ClusteringLauncher(ClusterMonitoringBeansRegistrar clusterMonitoringBeansRegistrar) {
        this.clusterMonitoringBeansRegistrar = clusterMonitoringBeansRegistrar;
    }

    @Override
    public void start() {
        FeatureManager featureManager;
        ClusterManager clusterManager = (ClusterManager)ComponentAccessor.getComponent(ClusterManager.class);
        if (clusterManager.isClustered()) {
            clusterManager.checkIndex();
        }
        if ((featureManager = (FeatureManager)ComponentAccessor.getComponent(FeatureManager.class)).isEnabled("jira.zdu.jmx-monitoring")) {
            this.clusterMonitoringBeansRegistrar.registerClusterMonitoringMBeans();
            this.clusterMonitoringStarted = true;
        }
    }

    @Override
    public void stop() {
        ClusterServicesManager clusterServicesManager = (ClusterServicesManager)ComponentAccessor.getComponent(ClusterServicesManager.class);
        clusterServicesManager.stopServices();
        if (this.clusterMonitoringStarted) {
            this.clusterMonitoringBeansRegistrar.unregisterClusterMonitorMBeans();
            this.clusterMonitoringStarted = false;
        }
    }
}

