/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.index;

import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.sharing.index.QueryBuilder;
import com.atlassian.jira.sharing.index.QueryFactory;
import com.atlassian.jira.sharing.search.SharedEntitySearchParameters;
import com.atlassian.jira.sharing.type.AuthenticatedUserShareQueryFactory;
import com.atlassian.jira.sharing.type.GlobalShareQueryFactory;
import com.atlassian.jira.sharing.type.GroupShareQueryFactory;
import com.atlassian.jira.sharing.type.PrivateShareQueryFactory;
import com.atlassian.jira.sharing.type.ProjectShareQueryFactory;
import com.atlassian.jira.user.ApplicationUser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Query;

public class PermissionQueryFactory
implements QueryFactory {
    private final PrivateShareQueryFactory privateShareQueryFactory = new PrivateShareQueryFactory();
    private final GlobalShareQueryFactory globalShareQueryFactory = new GlobalShareQueryFactory();
    private final AuthenticatedUserShareQueryFactory authenticatedUserShareQueryFactory = new AuthenticatedUserShareQueryFactory();
    private final ProjectShareQueryFactory projectShareQueryFactory;
    private final GroupShareQueryFactory groupShareQueryFactory;

    public PermissionQueryFactory(ProjectShareQueryFactory projectShareQueryFactory, GroupManager groupManager) {
        this.projectShareQueryFactory = projectShareQueryFactory;
        this.groupShareQueryFactory = new GroupShareQueryFactory(groupManager);
    }

    @Override
    public Query create(SharedEntitySearchParameters searchParameters, ApplicationUser user) {
        QueryBuilder builder = new QueryBuilder();
        builder.add(this.privateShareQueryFactory.getTerms(user), BooleanClause.Occur.SHOULD);
        builder.add(this.globalShareQueryFactory.getTerms(user), BooleanClause.Occur.SHOULD);
        builder.add(this.authenticatedUserShareQueryFactory.getTerms(user), BooleanClause.Occur.SHOULD);
        builder.add(this.groupShareQueryFactory.getTerms(user), BooleanClause.Occur.SHOULD);
        builder.add(this.projectShareQueryFactory.getTerms(user), BooleanClause.Occur.SHOULD);
        return builder.toQuery();
    }

    @Override
    public Query create(SharedEntitySearchParameters searchParameters) {
        throw new UnsupportedOperationException();
    }
}

