/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.setup;

import com.atlassian.fugue.Iterables;
import com.atlassian.fugue.Option;
import com.atlassian.jira.setup.SetupStrategy;
import com.atlassian.jira.util.thread.JiraThreadLocalUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class AsynchronousJiraSetup<ParametersT, StepT> {
    private static final Logger log = Logger.getLogger(AsynchronousJiraSetup.class);
    private volatile boolean bundleHasLicenseError = false;
    private final SetupStrategy<ParametersT, StepT> setupStrategy;
    private final Object lock = new Object();
    private String setupSessionId;
    private Option<StepT> currentStep;
    private final Map<StepT, SetupStrategy.Status> setupStatus;
    private String setupError;

    public boolean isBundleHasLicenseError() {
        return this.bundleHasLicenseError;
    }

    AsynchronousJiraSetup(SetupStrategy<ParametersT, StepT> setupStrategy) {
        this.setupStrategy = setupStrategy;
        this.setupStatus = new HashMap<StepT, SetupStrategy.Status>(setupStrategy.getInitialSteps());
        this.currentStep = AsynchronousJiraSetup.getPendingStep(this.setupStatus);
        if (!this.currentStep.isDefined()) {
            throw new RuntimeException("Strategy " + setupStrategy.getClass().getName() + " does not define pending step");
        }
    }

    private static <Step> Option<Step> getPendingStep(Map<Step, SetupStrategy.Status> steps) {
        ImmutableSetMultimap stepsForStatuses = ImmutableSetMultimap.copyOf((Multimap)Multimaps.forMap(steps)).inverse();
        return Iterables.first((Iterable)stepsForStatuses.get((Object)SetupStrategy.Status.PENDING));
    }

    public boolean isSetupFinished(String setupSessionId) {
        Object object = this.lock;
        synchronized (object) {
            if (setupSessionId != null && setupSessionId.equals(this.setupSessionId)) {
                return !this.currentStep.isDefined();
            }
            throw new RuntimeException("This can be executed only from the session that initiated setup");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SetupStatus<StepT> getStatusOnceStepIsDone(String sessionId, StepT step) {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (sessionId == null || !sessionId.equals(this.setupSessionId)) {
                    throw new RuntimeException("This can be executed only from the session that initiated setup");
                }
                while (this.currentStep.getOrNull() == step) {
                    this.lock.wait();
                }
                return new SetupStatus(ImmutableMap.copyOf(this.setupStatus), this.setupError);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setupJIRA(String setupSessionId, final ParametersT parameters) {
        Object object = this.lock;
        synchronized (object) {
            if (this.setupSessionId != null) {
                throw new RuntimeException("Can be done only once");
            }
            this.setupSessionId = setupSessionId;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                JiraThreadLocalUtils.preCall();
                try {
                    AsynchronousJiraSetup.this.doSetupJIRA(parameters);
                }
                finally {
                    JiraThreadLocalUtils.postCall(log, null);
                }
            }
        }, "AsynchronousJiraSetup").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSetupJIRA(ParametersT parameters) {
        try {
            this.setupStrategy.setup(parameters, new StepSwitcher());
            Object object = this.lock;
            synchronized (object) {
                this.setupStatus.put(this.currentStep.get(), SetupStrategy.Status.SUCCESS);
                this.currentStep = Option.none();
                this.lock.notifyAll();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error during SetupFinishing", (Throwable)e);
            Object object = this.lock;
            synchronized (object) {
                this.setupStatus.put(this.currentStep.get(), SetupStrategy.Status.FAILURE);
                this.setupError = e.getMessage();
                this.currentStep = Option.none();
                this.lock.notifyAll();
            }
        }
    }

    public static final class SetupStatus<T> {
        private final ImmutableMap<T, SetupStrategy.Status> steps;
        private final String error;

        private SetupStatus(ImmutableMap<T, SetupStrategy.Status> steps, String error) {
            this.steps = steps;
            this.error = error;
        }

        public ImmutableMap<T, SetupStrategy.Status> getSteps() {
            return this.steps;
        }

        public String getError() {
            return this.error;
        }
    }

    private class StepSwitcher
    implements SetupStrategy.StepSwitcher<StepT> {
        private StepSwitcher() {
        }

        @Override
        public void setBundleHasLicenseError(boolean bundleHasLicenseError) {
            AsynchronousJiraSetup.this.bundleHasLicenseError = bundleHasLicenseError;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void withStep(StepT step, SetupStrategy.StepTask task) throws Exception {
            Object object = AsynchronousJiraSetup.this.lock;
            synchronized (object) {
                AsynchronousJiraSetup.this.setupStatus.put(AsynchronousJiraSetup.this.currentStep.get(), SetupStrategy.Status.SUCCESS);
                AsynchronousJiraSetup.this.currentStep = Option.some(step);
                AsynchronousJiraSetup.this.setupStatus.put(step, SetupStrategy.Status.PENDING);
                AsynchronousJiraSetup.this.lock.notifyAll();
            }
            task.run();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setError(String error) {
            Object object = AsynchronousJiraSetup.this.lock;
            synchronized (object) {
                AsynchronousJiraSetup.this.setupError = error;
            }
        }
    }
}

