/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.servlet;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.crowd.embedded.ofbiz.ExtendedUserDao;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.util.johnson.DefaultJohnsonProvider;
import com.atlassian.jira.util.johnson.JohnsonProvider;
import com.atlassian.jira.util.system.status.ApplicationState;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ApplicationStatusServlet
extends HttpServlet {
    private static final Set<String> ERROR_LEVELS = ImmutableSet.of((Object)"error", (Object)"fatal");

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ApplicationState state = this.getApplicationState();
        resp.setStatus(state == ApplicationState.ERROR ? 500 : 200);
        resp.setContentType("application/json");
        resp.getWriter().append("{\"state\":\"").append(state.name()).append("\"}");
    }

    private ApplicationState getApplicationState() {
        if (ApplicationStatusServlet.hasErrors()) {
            return ApplicationState.ERROR;
        }
        if (!this.hasStarted()) {
            return ApplicationState.STARTING;
        }
        if (ApplicationStatusServlet.isFirstRun()) {
            return ApplicationState.FIRST_RUN;
        }
        if (!this.isUserCacheInitialized()) {
            return ApplicationState.STARTING;
        }
        if (this.isJohnsoned()) {
            return ApplicationState.MAINTENANCE;
        }
        return ApplicationState.RUNNING;
    }

    private boolean isJohnsoned() {
        return !ApplicationStatusServlet.getJohnsonEvents().isEmpty();
    }

    private static boolean hasErrors() {
        return ApplicationStatusServlet.getJohnsonEvents().stream().map(Event::getLevel).filter(Objects::nonNull).map(EventLevel::getLevel).anyMatch(ERROR_LEVELS::contains);
    }

    private boolean hasStarted() {
        ComponentManager.State state = this.getState();
        return state.isComponentsRegistered() && state.isContainerInitialised() && state.isPluginSystemStarted() && state.isStarted();
    }

    @VisibleForTesting
    protected ComponentManager.State getState() {
        return ComponentManager.getInstance().getState();
    }

    private static Collection<Event> getJohnsonEvents() {
        return ComponentAccessor.getComponentSafely(JohnsonProvider.class).orElseGet(DefaultJohnsonProvider::new).getContainer().getEvents();
    }

    private static boolean isFirstRun() {
        return !JiraUtils.isSetup();
    }

    @VisibleForTesting
    protected boolean isUserCacheInitialized() {
        return ComponentAccessor.getComponentSafely(ExtendedUserDao.class).map(ExtendedUserDao::isCacheInitialized).orElse(false);
    }
}

