/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service.services.analytics.start;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.license.LicenseCountService;
import com.atlassian.jira.service.services.analytics.JiraAnalyticTask;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.collect.MapBuilder;
import com.google.common.annotations.VisibleForTesting;
import java.util.Map;

public class UserAnalyticTask
implements JiraAnalyticTask {
    private LicenseCountService licenseCountService;
    private UserManager userManager;

    public UserAnalyticTask() {
    }

    @VisibleForTesting
    UserAnalyticTask(LicenseCountService licenseCountService, UserManager userManager) {
        this.licenseCountService = licenseCountService;
        this.userManager = userManager;
    }

    @Override
    public void init() {
        this.licenseCountService = (LicenseCountService)ComponentAccessor.getComponent(LicenseCountService.class);
        this.userManager = (UserManager)ComponentAccessor.getComponent(UserManager.class);
    }

    @Override
    public Map<String, Object> getAnalytics() {
        MapBuilder builder = MapBuilder.newBuilder();
        builder.add((Object)"users.total", (Object)this.userManager.getTotalUserCount());
        builder.add((Object)"users.active", (Object)this.licenseCountService.totalBillableUsers());
        return builder.toMap();
    }

    @Override
    public boolean isReportingDataShape() {
        return true;
    }
}

