/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.type;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.GroupSelectorField;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.permission.PermissionContext;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.type.AbstractIssueFieldSecurityType;
import com.atlassian.jira.security.util.GroupSelectorUtils;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupCF
extends AbstractIssueFieldSecurityType {
    private static final Logger log = LoggerFactory.getLogger(GroupCF.class);
    public static final String TYPE = "groupCF";
    private JiraAuthenticationContext jiraAuthenticationContext;
    private GroupSelectorUtils groupSelectorUtils;
    private final CustomFieldManager customFieldManager;
    private final GroupManager groupManager;

    public GroupCF(JiraAuthenticationContext jiraAuthenticationContext, GroupSelectorUtils groupSelectorUtils, CustomFieldManager customFieldManager, GroupManager groupManager) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.groupSelectorUtils = groupSelectorUtils;
        this.customFieldManager = customFieldManager;
        this.groupManager = groupManager;
    }

    @Override
    public String getDisplayName() {
        return this.jiraAuthenticationContext.getI18nHelper().getText("admin.permission.types.group.custom.field");
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    @Nullable
    protected BooleanQuery getQueryForProject(@Nonnull Project project, @Nullable ApplicationUser searcher, @Nonnull String fieldName) {
        Collection groupNames = this.groupManager.getGroupNamesForUser(searcher.getName());
        if (groupNames != null && !groupNames.isEmpty()) {
            BooleanQuery projectAndGroupQuery = new BooleanQuery();
            TermQuery projectQuery = new TermQuery(new Term("projid", project.getId().toString()));
            projectAndGroupQuery.add((Query)projectQuery, BooleanClause.Occur.MUST);
            BooleanQuery groupQuery = this.getQueryForGroups(groupNames, fieldName);
            projectAndGroupQuery.add((Query)groupQuery, BooleanClause.Occur.MUST);
            return projectAndGroupQuery;
        }
        return null;
    }

    private BooleanQuery getQueryForGroups(Collection<String> groupNames, String fieldName) {
        BooleanQuery groupQuery = new BooleanQuery();
        for (String groupName : groupNames) {
            CustomField customField = this.customFieldManager.getCustomFieldObject(fieldName);
            Query queryForGroupName = this.getQueryForGroupName(customField, groupName, fieldName);
            groupQuery.add(queryForGroupName, BooleanClause.Occur.SHOULD);
        }
        return groupQuery;
    }

    private Query getQueryForGroupName(CustomField customField, String groupName, String fieldName) {
        if (customField.getCustomFieldType() instanceof GroupSelectorField) {
            return ((GroupSelectorField)customField.getCustomFieldType()).getQueryForGroup(fieldName, groupName);
        }
        return new TermQuery(new Term(fieldName, groupName));
    }

    @Override
    protected BooleanQuery getQueryForSecurityLevel(IssueSecurityLevel issueSecurity, ApplicationUser searcher, String fieldName) {
        Collection groupNames = this.groupManager.getGroupNamesForUser(searcher.getName());
        if (groupNames != null && !groupNames.isEmpty()) {
            BooleanQuery securityLevelAndGroupQuery = new BooleanQuery();
            TermQuery securityLevelQuery = new TermQuery(new Term("issue_security_level", issueSecurity.getId().toString()));
            securityLevelAndGroupQuery.add((Query)securityLevelQuery, BooleanClause.Occur.MUST);
            BooleanQuery groupQuery = this.getQueryForGroups(groupNames, fieldName);
            securityLevelAndGroupQuery.add((Query)groupQuery, BooleanClause.Occur.MUST);
            return securityLevelAndGroupQuery;
        }
        return null;
    }

    @Override
    public void doValidation(String key, Map<String, String> parameters, JiraServiceContext jiraServiceContext) {
        String customFieldOption = parameters.get(this.getType());
        if (StringUtils.isEmpty((String)customFieldOption)) {
            String localisedMessage = jiraServiceContext.getI18nBean().getText("admin.permissions.errors.please.select.group.customfield");
            jiraServiceContext.getErrorCollection().addErrorMessage(localisedMessage);
        } else {
            CustomField customField = this.customFieldManager.getCustomFieldObject(customFieldOption);
            if (customField != null && customField.getCustomFieldSearcher() == null) {
                String localisedMessage = jiraServiceContext.getI18nBean().getText("admin.permissions.errors.customfieldnotindexed", customField.getName());
                jiraServiceContext.getErrorCollection().addErrorMessage(localisedMessage);
            }
        }
    }

    @Override
    protected String getFieldName(String parameter) {
        return parameter;
    }

    @Override
    protected boolean hasProjectPermission(ApplicationUser user, boolean issueCreation, Project project) {
        return !issueCreation;
    }

    @Override
    protected boolean hasIssuePermission(ApplicationUser user, boolean issueCreation, Issue issue, String parameter) {
        CustomFieldManager customFieldManager = ComponentAccessor.getCustomFieldManager();
        boolean hasPermission = false;
        CustomField field = customFieldManager.getCustomFieldObject(parameter);
        if (field == null) {
            log.warn("custom field '" + parameter + "' is missing, can't use it to determine permissions.");
        } else {
            hasPermission = this.groupSelectorUtils.isUserInCustomFieldGroup(issue, field, user);
        }
        return hasPermission;
    }

    public List<Field> getDisplayFields() {
        return this.groupSelectorUtils.getCustomFieldsSpecifyingGroups();
    }

    @Override
    public String getArgumentDisplay(String argument) {
        FieldManager fieldManager = ComponentAccessor.getFieldManager();
        if (fieldManager.isCustomField(argument)) {
            CustomField field = fieldManager.getCustomField(argument);
            return field.getName();
        }
        return argument;
    }

    @Override
    public Set<ApplicationUser> getUsers(PermissionContext ctx, String customFieldId) {
        return this.groupSelectorUtils.getUsers(ctx.getIssue(), customFieldId);
    }
}

