/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.auth.trustedapps;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.cache.SingleValueLocalCache;
import com.atlassian.jira.cache.SwitchingCacheFactory;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationData;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationStore;
import com.atlassian.jira.tenancy.TenantAware;
import com.atlassian.jira.tenancy.TenantInfo;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@TenantInfo(value=TenantAware.UNRESOLVED, comment="Marked as unresolved until we move this class to vcache only")
@EventComponent
public final class CachingTrustedApplicationStore
implements TrustedApplicationStore {
    public static final String DARK_FEATURE = "jira.jvc.CachingTrustedApplicationStore.caches.request";
    private final TrustedApplicationStore delegate;
    @TenantInfo(value=TenantAware.TENANTED)
    private final SingleValueLocalCache<TrustedApplications> cache;

    public CachingTrustedApplicationStore(TrustedApplicationStore delegate, SwitchingCacheFactory switchingCacheFactory) {
        this.delegate = delegate;
        this.cache = switchingCacheFactory.buildSwitchingRequestCache(this.getClass().getName() + ".cache", () -> new TrustedApplications(delegate.getAll()), DARK_FEATURE);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.cache.reset();
    }

    @Override
    public Set<TrustedApplicationData> getAll() {
        return this.cache.get().getAll();
    }

    @Override
    public TrustedApplicationData getByApplicationId(String applicationId) {
        return this.cache.get().get(applicationId);
    }

    @Override
    public TrustedApplicationData getById(long id) {
        return this.cache.get().get(id);
    }

    @Override
    public TrustedApplicationData store(TrustedApplicationData trustedApplicationData) {
        TrustedApplicationData result = this.delegate.store(trustedApplicationData);
        this.cache.reset();
        return result;
    }

    @Override
    public boolean delete(long id) {
        boolean result = this.delegate.delete(id);
        this.cache.reset();
        return result;
    }

    @Override
    public boolean delete(String applicationId) {
        boolean result = this.delegate.delete(applicationId);
        this.cache.reset();
        return result;
    }

    private static final class TrustedApplications {
        final Map<Long, TrustedApplicationData> byId;
        final Map<String, TrustedApplicationData> byAppId;

        TrustedApplications(Set<TrustedApplicationData> datas) {
            HashMap<Long, TrustedApplicationData> byId = new HashMap<Long, TrustedApplicationData>(datas.size());
            HashMap<String, TrustedApplicationData> byAppId = new HashMap<String, TrustedApplicationData>(datas.size());
            for (TrustedApplicationData data : datas) {
                byId.put(data.getId(), data);
                byAppId.put(data.getApplicationId(), data);
            }
            this.byId = Collections.unmodifiableMap(byId);
            this.byAppId = Collections.unmodifiableMap(byAppId);
        }

        TrustedApplicationData get(long id) {
            return this.byId.get(id);
        }

        TrustedApplicationData get(String applicationId) {
            return this.byAppId.get(applicationId);
        }

        Set<TrustedApplicationData> getAll() {
            return ImmutableSet.copyOf(this.byId.values());
        }
    }
}

