/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.propertyset;

import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.propertyset.JiraCachingPropertySet;
import com.atlassian.jira.propertyset.OfBizPropertyEntryStore;
import com.atlassian.jira.tenancy.TenantAware;
import com.atlassian.jira.tenancy.TenantInfo;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.opensymphony.module.propertyset.PropertyImplementationException;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.ofbiz.OFBizPropertySet;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.w3c.dom.Document;

@ParametersAreNonnullByDefault
@TenantInfo(value=TenantAware.TENANTED, comment="This component is only used when JIRA isn't configured, yet.")
@ClusterSafe(value="Only used during bootstrap; this component is discarded afterwards")
public class BootstrapOfBizPropertyEntryStore
implements OfBizPropertyEntryStore {
    private final LoadingCache<CacheKey, PropertySet> propertySets = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build((CacheLoader)new PropertySetLoader());

    @Override
    @Nonnull
    public Collection<String> getKeys(String entityName, long entityId) {
        return this.getPropertySet(entityName, entityId).getKeys();
    }

    @Override
    @Nonnull
    public Collection<String> getKeys(String entityName, long entityId, int type) {
        return this.getPropertySet(entityName, entityId).getKeys(type);
    }

    @Override
    public boolean exists(String entityName, long entityId, String propertyKey) {
        PropertySet ps = this.getPropertySet(entityName, entityId);
        return ps.exists(propertyKey);
    }

    @Override
    public int getType(String entityName, long entityId, String propertyKey) {
        PropertySet ps = this.getPropertySet(entityName, entityId);
        return ps.exists(propertyKey) ? ps.getType(propertyKey) : 0;
    }

    @Override
    @Nullable
    public OfBizPropertyEntryStore.PropertyEntry getEntry(String entityName, long entityId, String propertyKey) {
        PropertySet ps = this.getPropertySet(entityName, entityId);
        return ps.exists(propertyKey) ? new PropertyEntryImpl(ps, propertyKey) : null;
    }

    @Override
    public void setEntry(String entityName, long entityId, String propertyKey, int type, Object value) {
        PropertySet ps = this.getPropertySet(entityName, entityId);
        switch (type) {
            case 1: {
                ps.setBoolean(propertyKey, ((Boolean)value).booleanValue());
                return;
            }
            case 7: {
                ps.setDate(propertyKey, (Date)value);
                return;
            }
            case 10: {
                ps.setData(propertyKey, (byte[])value);
                return;
            }
            case 3: {
                ps.setLong(propertyKey, ((Long)value).longValue());
                return;
            }
            case 2: {
                ps.setInt(propertyKey, ((Integer)value).intValue());
                return;
            }
            case 4: {
                ps.setDouble(propertyKey, ((Double)value).doubleValue());
                return;
            }
            case 8: {
                ps.setObject(propertyKey, value);
                return;
            }
            case 9: {
                ps.setXML(propertyKey, (Document)value);
                return;
            }
            case 11: {
                ps.setProperties(propertyKey, (Properties)value);
                return;
            }
            case 5: {
                ps.setString(propertyKey, (String)value);
                return;
            }
            case 6: {
                ps.setText(propertyKey, (String)value);
                return;
            }
        }
        throw new PropertyImplementationException("Unrecognized property type: " + type);
    }

    @Override
    public void removeEntry(String entityName, long entityId, String propertyKey) {
        PropertySet ps = this.getPropertySet(entityName, entityId);
        if (ps.exists(propertyKey)) {
            ps.remove(propertyKey);
        }
    }

    @Override
    public void removePropertySet(String entityName, long entityId) {
        this.getPropertySet(entityName, entityId).remove();
    }

    private PropertySet getPropertySet(String entityName, long entityId) {
        return (PropertySet)this.propertySets.getUnchecked((Object)new CacheKey(entityName, entityId));
    }

    static class PropertyEntryImpl
    implements OfBizPropertyEntryStore.PropertyEntry {
        private final PropertySet propertySet;
        private final String propertyKey;

        PropertyEntryImpl(PropertySet propertySet, String propertyKey) {
            this.propertySet = propertySet;
            this.propertyKey = propertyKey;
        }

        @Override
        public int getType() {
            return this.propertySet.getType(this.propertyKey);
        }

        @Override
        @Nullable
        public Object getValue() {
            return this.propertySet.getAsActualType(this.propertyKey);
        }

        @Override
        @Nullable
        public Object getValue(int type) {
            switch (type) {
                case 5: {
                    return this.propertySet.getString(this.propertyKey);
                }
                case 6: {
                    return this.propertySet.getText(this.propertyKey);
                }
                case 3: {
                    return this.propertySet.getLong(this.propertyKey);
                }
                case 2: {
                    return this.propertySet.getInt(this.propertyKey);
                }
                case 1: {
                    return this.propertySet.getBoolean(this.propertyKey);
                }
                case 7: {
                    return this.propertySet.getDate(this.propertyKey);
                }
                case 4: {
                    return this.propertySet.getDouble(this.propertyKey);
                }
                case 11: {
                    return this.propertySet.getProperties(this.propertyKey);
                }
                case 10: {
                    return this.propertySet.getData(this.propertyKey);
                }
                case 9: {
                    return this.propertySet.getXML(this.propertyKey);
                }
                case 8: {
                    return this.propertySet.getObject(this.propertyKey);
                }
            }
            throw new PropertyImplementationException("Unsupported property type: " + type);
        }
    }

    static class PropertySetLoader
    extends CacheLoader<CacheKey, PropertySet> {
        PropertySetLoader() {
        }

        public PropertySet load(@Nonnull CacheKey key) throws Exception {
            OFBizPropertySet uncached = new OFBizPropertySet();
            uncached.init((Map)ImmutableMap.of(), (Map)FieldMap.build((String)"entityName", (Object)key.getEntityName(), (String)"entityId", (Object)key.getEntityId()));
            JiraCachingPropertySet cached = new JiraCachingPropertySet();
            cached.init((Map)ImmutableMap.of(), (Map)FieldMap.build((String)"PropertySet", (Object)uncached));
            return cached;
        }
    }

    static class CacheKey {
        private final String entityName;
        private final long entityId;

        CacheKey(String entityName, long entityId) {
            this.entityName = (String)Assertions.notNull((String)"entityName", (Object)entityName);
            this.entityId = entityId;
        }

        String getEntityName() {
            return this.entityName;
        }

        long getEntityId() {
            return this.entityId;
        }

        public boolean equals(Object o) {
            return o instanceof CacheKey && this.equals((CacheKey)o);
        }

        private boolean equals(@Nonnull CacheKey other) {
            return this.entityId == other.entityId && this.entityName.equals(other.entityName);
        }

        public int hashCode() {
            return 31 * this.entityName.hashCode() + (int)(this.entityId ^ this.entityId >>> 32);
        }
    }
}

