/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.version;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.fugue.Option;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.model.querydsl.QCustomField;
import com.atlassian.jira.model.querydsl.QCustomFieldValue;
import com.atlassian.jira.project.version.CustomFieldVersionTransformation;
import com.atlassian.jira.project.version.CustomFieldWithVersionUsage;
import com.atlassian.jira.project.version.DeleteVersionWithCustomFieldParameters;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionCollectionManipulators;
import com.atlassian.jira.util.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.sql.SQLQuery;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class VersionCustomFieldStore {
    private final QueryDslAccessor queryDslAccessor;
    final Supplier<CustomFieldManager> customFieldManagerSupplier;

    public VersionCustomFieldStore(QueryDslAccessor queryDslAccessor) {
        this.queryDslAccessor = queryDslAccessor;
        this.customFieldManagerSupplier = Suppliers.memoize(ComponentAccessor::getCustomFieldManager);
    }

    @Nonnull
    public List<CustomFieldVersionTransformation> createValueReplacers(Version deletedVersion, List<DeleteVersionWithCustomFieldParameters.CustomFieldReplacement> customFieldReplacementList) {
        Collection<CustomField> customFieldsTypesUsing = this.getCustomFieldsTypesUsing(deletedVersion);
        Map<Long, Version> customFieldIdToTargetVersion = customFieldReplacementList.stream().filter(replacemet -> replacemet.getMoveTo().isPresent()).collect(Collectors.toMap(DeleteVersionWithCustomFieldParameters.CustomFieldReplacement::getCustomFieldId, replacement -> (Version)replacement.getMoveTo().get()));
        return (List)customFieldsTypesUsing.stream().map(customField -> {
            Option replacements = Option.option(customFieldIdToTargetVersion.get(customField.getIdAsLong()));
            return this.getCustomFieldTransformer(deletedVersion, (CustomField)customField, (Option<Version>)replacements);
        }).collect(CollectorsUtil.toImmutableListWithSizeOf(customFieldsTypesUsing));
    }

    @Nonnull
    public List<CustomFieldVersionTransformation> createValueReplacers(Version deletedVersion, Option<Version> targetVersion) {
        Collection<CustomField> customFieldsTypesUsing = this.getCustomFieldsTypesUsing(deletedVersion);
        return (List)customFieldsTypesUsing.stream().map(customField -> this.getCustomFieldTransformer(deletedVersion, (CustomField)customField, targetVersion)).collect(CollectorsUtil.toImmutableListWithSizeOf(customFieldsTypesUsing));
    }

    private CustomFieldVersionTransformation getCustomFieldTransformer(Version deletedVersion, CustomField customField, Option<Version> replacement) {
        return new CustomFieldVersionTransformation(customField, (Function<Collection<Version>, Collection<Version>>)((Function)replacement.fold(() -> VersionCollectionManipulators.versionRemover(deletedVersion), versionReplacement -> VersionCollectionManipulators.versionReplacer(deletedVersion, versionReplacement))));
    }

    @Nonnull
    public Collection<? extends CustomFieldWithVersionUsage> getCustomFieldsUsing(Version version) {
        Preconditions.checkNotNull((Object)version.getId());
        return this.queryDslAccessor.executeQuery(connection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.newSqlQuery().select((Expression)Projections.constructor(CustomFieldUsageImpl.class, (Expression[])new Expression[]{QCustomFieldValue.CUSTOM_FIELD_VALUE.customfield, QCustomField.CUSTOM_FIELD.name, QCustomFieldValue.CUSTOM_FIELD_VALUE.issue.countDistinct()})).from((Expression)QCustomFieldValue.CUSTOM_FIELD_VALUE)).leftJoin((EntityPath)QCustomField.CUSTOM_FIELD)).on((Predicate)QCustomFieldValue.CUSTOM_FIELD_VALUE.customfield.eq(QCustomField.CUSTOM_FIELD.id))).where((Predicate)QCustomFieldValue.CUSTOM_FIELD_VALUE.numbervalue.eq((Object)version.getId().doubleValue()).and((Predicate)QCustomField.CUSTOM_FIELD.customfieldtypekey.eq((Object)"com.atlassian.jira.plugin.system.customfieldtypes:version").or((Predicate)QCustomField.CUSTOM_FIELD.customfieldtypekey.eq((Object)"com.atlassian.jira.plugin.system.customfieldtypes:multiversion"))))).groupBy(new Expression[]{QCustomField.CUSTOM_FIELD.name, QCustomFieldValue.CUSTOM_FIELD_VALUE.customfield})).fetch());
    }

    @Nonnull
    public Collection<CustomField> getCustomFieldsTypesUsing(Version version) {
        Preconditions.checkNotNull((Object)version.getId());
        List customFieldIds = this.queryDslAccessor.executeQuery(connection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.newSqlQuery().select(QCustomFieldValue.CUSTOM_FIELD_VALUE.customfield).from((Expression)QCustomFieldValue.CUSTOM_FIELD_VALUE)).leftJoin((EntityPath)QCustomField.CUSTOM_FIELD)).on((Predicate)QCustomFieldValue.CUSTOM_FIELD_VALUE.customfield.eq(QCustomField.CUSTOM_FIELD.id))).where((Predicate)QCustomFieldValue.CUSTOM_FIELD_VALUE.numbervalue.eq((Object)version.getId().doubleValue()).and((Predicate)QCustomField.CUSTOM_FIELD.customfieldtypekey.eq((Object)"com.atlassian.jira.plugin.system.customfieldtypes:version").or((Predicate)QCustomField.CUSTOM_FIELD.customfieldtypekey.eq((Object)"com.atlassian.jira.plugin.system.customfieldtypes:multiversion"))))).distinct()).fetch());
        CustomFieldManager customFieldManager = (CustomFieldManager)this.customFieldManagerSupplier.get();
        return (Collection)customFieldIds.stream().map(arg_0 -> ((CustomFieldManager)customFieldManager).getCustomFieldObject(arg_0)).collect(CollectorsUtil.toImmutableListWithSizeOf((Collection)customFieldIds));
    }

    public List<Long> getIssueIdsWithCustomFieldsFor(@Nonnull Version version) {
        Preconditions.checkNotNull((Object)version.getId());
        return this.queryDslAccessor.executeQuery(connection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.newSqlQuery().select(QCustomFieldValue.CUSTOM_FIELD_VALUE.issue).from((Expression)QCustomFieldValue.CUSTOM_FIELD_VALUE)).leftJoin((EntityPath)QCustomField.CUSTOM_FIELD)).on((Predicate)QCustomFieldValue.CUSTOM_FIELD_VALUE.customfield.eq(QCustomField.CUSTOM_FIELD.id))).where((Predicate)QCustomFieldValue.CUSTOM_FIELD_VALUE.numbervalue.eq((Object)version.getId().doubleValue()).and((Predicate)QCustomField.CUSTOM_FIELD.customfieldtypekey.eq((Object)"com.atlassian.jira.plugin.system.customfieldtypes:version").or((Predicate)QCustomField.CUSTOM_FIELD.customfieldtypekey.eq((Object)"com.atlassian.jira.plugin.system.customfieldtypes:multiversion"))))).distinct()).fetch());
    }

    public long getCustomFieldIssuesCount(Version version) {
        Preconditions.checkNotNull((Object)version.getId());
        return this.queryDslAccessor.executeQuery(connection -> (Long)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.newSqlQuery().select((Expression)QCustomFieldValue.CUSTOM_FIELD_VALUE.issue.countDistinct()).from((Expression)QCustomFieldValue.CUSTOM_FIELD_VALUE)).leftJoin((EntityPath)QCustomField.CUSTOM_FIELD)).on((Predicate)QCustomFieldValue.CUSTOM_FIELD_VALUE.customfield.eq(QCustomField.CUSTOM_FIELD.id))).where((Predicate)QCustomFieldValue.CUSTOM_FIELD_VALUE.numbervalue.eq((Object)version.getId().doubleValue()).and((Predicate)QCustomField.CUSTOM_FIELD.customfieldtypekey.eq((Object)"com.atlassian.jira.plugin.system.customfieldtypes:version").or((Predicate)QCustomField.CUSTOM_FIELD.customfieldtypekey.eq((Object)"com.atlassian.jira.plugin.system.customfieldtypes:multiversion"))))).fetchOne());
    }

    public static class CustomFieldUsageImpl
    implements CustomFieldWithVersionUsage {
        private final long customFieldId;
        private final String fieldName;
        private final long fieldCount;

        public CustomFieldUsageImpl(long customFieldId, String fieldName, long fieldCount) {
            this.fieldName = fieldName;
            this.fieldCount = fieldCount;
            this.customFieldId = customFieldId;
        }

        public long getCustomFieldId() {
            return this.customFieldId;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public long getIssueCountWithVersionInCustomField() {
            return this.fieldCount;
        }
    }
}

