/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.version;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.Longs;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class VersionCollectionManipulators {
    public static Function<Collection<Version>, Collection<Version>> versionReplacer(Version versionToRemove, Version versionToSwap) {
        Long versionToRemoveId = versionToRemove.getId();
        return versions -> versions == null ? null : (Collection)versions.stream().map(input -> Longs.nullableLongsEquals((Long)versionToRemoveId, (Long)input.getId()) ? versionToSwap : input).collect(CollectorsUtil.toNewArrayListWithSizeOf((Collection)versions));
    }

    public static Function<Collection<Version>, Collection<Version>> versionRemover(Version versionToRemove) {
        Long versionToRemoveId = versionToRemove.getId();
        return versions -> versions == null ? null : (Collection)versions.stream().filter(input -> !Longs.nullableLongsEquals((Long)versionToRemoveId, (Long)input.getId())).collect(CollectorsUtil.toNewArrayListWithSizeOf((Collection)versions));
    }

    public static <T, T2> void updateValueIfChangedAfterTranformation(T originalValue, Function<T, T2> transformer, Consumer<T2> valueConsumer) {
        Object modifiedValue = transformer.get(originalValue);
        if (!Objects.equals(originalValue, modifiedValue)) {
            valueConsumer.accept(modifiedValue);
        }
    }
}

