/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.type;

import com.atlassian.application.api.Application;
import com.atlassian.fugue.Option;
import com.atlassian.jira.application.JiraApplication;
import com.atlassian.jira.project.type.JiraApplicationAdapter;
import com.atlassian.jira.project.type.ProjectType;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.project.type.ProjectTypeManager;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

public class ProjectTypeManagerImpl
implements ProjectTypeManager {
    private static final ProjectTypeKey INACCESSIBLE_KEY = new ProjectTypeKey("jira-project-type-inaccessible");
    private static final String INACCESSIBLE_DESC = "jira.project.type.inaccessible.description";
    private static final String INACCESSIBLE_ICON = "PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0idXRmLTgiPz4NCjwhLS0gR2VuZXJhdG9yOiBBZG9iZSBJbGx1c3RyYXRvciAxOC4xLjEsIFNWRyBFeHBvcnQgUGx1Zy1JbiAuIFNWRyBWZXJzaW9uOiA2LjAwIEJ1aWxkIDApICAtLT4NCjxzdmcgdmVyc2lvbj0iMS4xIiBpZD0iTGF5ZXJfMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayIgeD0iMHB4IiB5PSIwcHgiDQoJIHZpZXdCb3g9IjAgMCAyMCAyMCIgZW5hYmxlLWJhY2tncm91bmQ9Im5ldyAwIDAgMjAgMjAiIHhtbDpzcGFjZT0icHJlc2VydmUiPg0KPGc+DQoJPHBhdGggZmlsbD0iIzk5OTk5OSIgZD0iTTAuMSw4LjljMC44LDAuMSwxLjUtMC4zLDEuNy0xLjFsMC0wLjFDMi4yLDYuNCwyLjksNS4xLDQsNEM0LjUsMy41LDQuNSwyLjYsNCwyQzIuMywzLjMsMC45LDUuMiwwLjMsNy40DQoJCUMwLjIsNy45LDAuMSw4LjQsMC4xLDguOXoiLz4NCgk8cGF0aCBmaWxsPSIjOTk5OTk5IiAgZD0iTTQuMSwxOC4xYzAuNS0wLjYsMC41LTEuNS0wLjEtMkMzLDE1LDIuMiwxMy43LDEuOCwxMi4yYy0wLjItMC44LTEtMS4yLTEuNy0xLjENCgkJQzAuNCwxMy45LDEuOSwxNi40LDQuMSwxOC4xeiIvPg0KCTxwYXRoIGZpbGw9IiM5OTk5OTkiICBkPSJNMTkuOSwxMS4xYy0wLjgtMC4xLTEuNSwwLjMtMS43LDEuMWMtMC40LDEuNC0xLjEsMi44LTIuMiwzLjhjLTAuNiwwLjYtMC42LDEuNC0wLjEsMg0KCQljMS44LTEuMywzLjEtMy4yLDMuNy01LjVDMTkuOCwxMi4xLDE5LjksMTEuNiwxOS45LDExLjF6Ii8+DQoJPHBhdGggZmlsbD0iIzk5OTk5OSIgIGQ9Ik0xNCwxOS4yYy0wLjMtMC43LTEtMS4yLTEuOC0wLjljLTEuNCwwLjQtMywwLjQtNC40LDBjLTAuOC0wLjItMS41LDAuMi0xLjgsMWMwLjQsMC4yLDAuOSwwLjQsMS40LDAuNQ0KCQlDOS43LDIwLjMsMTIsMjAsMTQsMTkuMnoiLz4NCgk8cGF0aCBmaWxsPSIjOTk5OTk5IiAgZD0iTTcuOCwxLjhjMS40LTAuNCwzLTAuNCw0LjQsMGMwLjgsMC4yLDEuNS0wLjIsMS44LTFjLTAuNC0wLjItMC45LTAuNC0xLjQtMC41QzEwLjMtMC4zLDgsMCw2LDAuOQ0KCQljMC4yLDAuNSwwLjYsMC44LDEsMC45QzcuMiwxLjksNy41LDEuOSw3LjgsMS44eiIvPg0KCTxwYXRoIGZpbGw9IiM5OTk5OTkiICBkPSJNMTkuMyw4LjhjMC4yLDAuMSwwLjQsMC4xLDAuNywwYy0wLjMtMi44LTEuOC01LjMtNC02LjljLTAuNSwwLjYtMC41LDEuNSwwLjEsMmMxLjEsMSwxLjgsMi40LDIuMiwzLjgNCgkJQzE4LjMsOC4zLDE4LjgsOC43LDE5LjMsOC44eiIvPg0KPC9nPg0KPC9zdmc+";
    private static final String INACCESSIBLE_COLOR = "#999999";
    public static final int INACCESSIBLE_WEIGHT = 1000000000;
    private static final ProjectType INACCESSIBLE_TYPE = new ProjectType(INACCESSIBLE_KEY, "jira.project.type.inaccessible.description", "PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0idXRmLTgiPz4NCjwhLS0gR2VuZXJhdG9yOiBBZG9iZSBJbGx1c3RyYXRvciAxOC4xLjEsIFNWRyBFeHBvcnQgUGx1Zy1JbiAuIFNWRyBWZXJzaW9uOiA2LjAwIEJ1aWxkIDApICAtLT4NCjxzdmcgdmVyc2lvbj0iMS4xIiBpZD0iTGF5ZXJfMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayIgeD0iMHB4IiB5PSIwcHgiDQoJIHZpZXdCb3g9IjAgMCAyMCAyMCIgZW5hYmxlLWJhY2tncm91bmQ9Im5ldyAwIDAgMjAgMjAiIHhtbDpzcGFjZT0icHJlc2VydmUiPg0KPGc+DQoJPHBhdGggZmlsbD0iIzk5OTk5OSIgZD0iTTAuMSw4LjljMC44LDAuMSwxLjUtMC4zLDEuNy0xLjFsMC0wLjFDMi4yLDYuNCwyLjksNS4xLDQsNEM0LjUsMy41LDQuNSwyLjYsNCwyQzIuMywzLjMsMC45LDUuMiwwLjMsNy40DQoJCUMwLjIsNy45LDAuMSw4LjQsMC4xLDguOXoiLz4NCgk8cGF0aCBmaWxsPSIjOTk5OTk5IiAgZD0iTTQuMSwxOC4xYzAuNS0wLjYsMC41LTEuNS0wLjEtMkMzLDE1LDIuMiwxMy43LDEuOCwxMi4yYy0wLjItMC44LTEtMS4yLTEuNy0xLjENCgkJQzAuNCwxMy45LDEuOSwxNi40LDQuMSwxOC4xeiIvPg0KCTxwYXRoIGZpbGw9IiM5OTk5OTkiICBkPSJNMTkuOSwxMS4xYy0wLjgtMC4xLTEuNSwwLjMtMS43LDEuMWMtMC40LDEuNC0xLjEsMi44LTIuMiwzLjhjLTAuNiwwLjYtMC42LDEuNC0wLjEsMg0KCQljMS44LTEuMywzLjEtMy4yLDMuNy01LjVDMTkuOCwxMi4xLDE5LjksMTEuNiwxOS45LDExLjF6Ii8+DQoJPHBhdGggZmlsbD0iIzk5OTk5OSIgIGQ9Ik0xNCwxOS4yYy0wLjMtMC43LTEtMS4yLTEuOC0wLjljLTEuNCwwLjQtMywwLjQtNC40LDBjLTAuOC0wLjItMS41LDAuMi0xLjgsMWMwLjQsMC4yLDAuOSwwLjQsMS40LDAuNQ0KCQlDOS43LDIwLjMsMTIsMjAsMTQsMTkuMnoiLz4NCgk8cGF0aCBmaWxsPSIjOTk5OTk5IiAgZD0iTTcuOCwxLjhjMS40LTAuNCwzLTAuNCw0LjQsMGMwLjgsMC4yLDEuNS0wLjIsMS44LTFjLTAuNC0wLjItMC45LTAuNC0xLjQtMC41QzEwLjMtMC4zLDgsMCw2LDAuOQ0KCQljMC4yLDAuNSwwLjYsMC44LDEsMC45QzcuMiwxLjksNy41LDEuOSw3LjgsMS44eiIvPg0KCTxwYXRoIGZpbGw9IiM5OTk5OTkiICBkPSJNMTkuMyw4LjhjMC4yLDAuMSwwLjQsMC4xLDAuNywwYy0wLjMtMi44LTEuOC01LjMtNC02LjljLTAuNSwwLjYtMC41LDEuNSwwLjEsMmMxLjEsMSwxLjgsMi40LDIuMiwzLjgNCgkJQzE4LjMsOC4zLDE4LjgsOC43LDE5LjMsOC44eiIvPg0KPC9nPg0KPC9zdmc+", "#999999", 1000000000);
    private final JiraApplicationAdapter adapter;

    public ProjectTypeManagerImpl(JiraApplicationAdapter adapter) {
        this.adapter = adapter;
    }

    public List<ProjectType> getAllProjectTypes() {
        ArrayList projectTypes = Lists.newArrayList(this.gatherProjectTypesFrom(this.adapter.getJiraApplications()));
        projectTypes.sort(Comparator.comparingInt(ProjectType::getWeight));
        return ImmutableList.copyOf((Collection)projectTypes);
    }

    public List<ProjectType> getAllAccessibleProjectTypes() {
        ArrayList projectTypes = Lists.newArrayList(this.getProjectTypesInstalledAndLicensed());
        projectTypes.sort(Comparator.comparingInt(ProjectType::getWeight));
        return ImmutableList.copyOf((Collection)projectTypes);
    }

    public Option<ProjectType> getByKey(ProjectTypeKey key) {
        return this.findProjectTypeByKey(this.getAllProjectTypes(), key);
    }

    public Option<Application> getApplicationWithType(ProjectTypeKey key) {
        for (JiraApplication jiraApplication : this.adapter.getJiraApplications()) {
            for (ProjectType projectType : jiraApplication.getProjectTypes()) {
                if (!projectType.getKey().equals((Object)key)) continue;
                return Option.option((Object)jiraApplication);
            }
        }
        return Option.none();
    }

    public Option<ProjectType> getAccessibleProjectType(ProjectTypeKey key) {
        return this.findProjectTypeByKey(this.getProjectTypesInstalledAndLicensed(), key);
    }

    private Iterable<ProjectType> getProjectTypesInstalledAndLicensed() {
        return this.gatherProjectTypesFrom(this.adapter.getAccessibleJiraApplications());
    }

    public Option<ProjectType> getAccessibleProjectType(ApplicationUser user, ProjectTypeKey key) {
        return this.findProjectTypeByKey(this.getProjectTypesInstalledAndLicensedForUser(user), key);
    }

    private Iterable<ProjectType> getProjectTypesInstalledAndLicensedForUser(ApplicationUser user) {
        return this.gatherProjectTypesFrom(this.adapter.getAccessibleJiraApplications(user));
    }

    public ProjectType getInaccessibleProjectType() {
        return INACCESSIBLE_TYPE;
    }

    public boolean isProjectTypeUninstalled(ProjectTypeKey projectTypeKey) {
        return this.getByKey(projectTypeKey).isEmpty();
    }

    public boolean isProjectTypeInstalledButInaccessible(ProjectTypeKey projectTypeKey) {
        return !this.isProjectTypeUninstalled(projectTypeKey) && this.getAccessibleProjectType(projectTypeKey).isEmpty();
    }

    private Option<ProjectType> findProjectTypeByKey(Iterable<ProjectType> types, ProjectTypeKey key) {
        for (ProjectType projectType : types) {
            if (!key.equals((Object)projectType.getKey())) continue;
            return Option.some((Object)projectType);
        }
        return Option.none();
    }

    private Iterable<ProjectType> gatherProjectTypesFrom(Iterable<JiraApplication> applications) {
        ArrayList projectTypes = Lists.newArrayList();
        for (JiraApplication application : applications) {
            Iterables.addAll((Collection)projectTypes, application.getProjectTypes());
        }
        return projectTypes;
    }
}

