/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.listener;

import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.project.ProjectChangedTimeStore;
import com.atlassian.jira.project.listener.ProjectIssueChangedEventAllowedTypes;
import com.atlassian.jira.project.listener.ProjectIssueChangedEventListener;
import java.sql.Timestamp;
import java.util.List;
import java.util.Optional;

public class ProjectIssueChangedEventListenerImpl
implements ProjectIssueChangedEventListener {
    private static final String PROJECT_FIELD_NAME = "project";
    private final ProjectChangedTimeStore projectChangedTimeStore;
    private final ChangeHistoryManager changeHistoryManager;

    public ProjectIssueChangedEventListenerImpl(ProjectChangedTimeStore projectChangedTimeStore, ChangeHistoryManager changeHistoryManager) {
        this.projectChangedTimeStore = projectChangedTimeStore;
        this.changeHistoryManager = changeHistoryManager;
    }

    @Override
    public void listenForIssueChangedEvent(IssueEvent issueEvent) {
        Long issueEventType = issueEvent.getEventTypeId();
        if (this.isAllowedIssueChangedEvent(issueEventType)) {
            long projectId = issueEvent.getProject().getId();
            Timestamp issueChangedTime = this.getIssueChangedTime(issueEvent);
            this.projectChangedTimeStore.updateOrAddIssueChangedTime(projectId, issueChangedTime);
            if (this.isIssueMoveEvent(issueEventType)) {
                this.getSourceProjectId(issueEvent).ifPresent(sourceProjectId -> this.projectChangedTimeStore.updateOrAddIssueChangedTime((long)sourceProjectId, issueChangedTime));
            }
        }
    }

    private Timestamp getIssueChangedTime(IssueEvent issueEvent) {
        return new Timestamp(issueEvent.getTime().getTime());
    }

    private boolean isAllowedIssueChangedEvent(Long eventTypeId) {
        return ProjectIssueChangedEventAllowedTypes.eventTypes.contains(eventTypeId);
    }

    private Optional<Long> getSourceProjectId(IssueEvent moveIssueEvent) {
        List changesToProjectField = this.changeHistoryManager.getChangeItemsForField(moveIssueEvent.getIssue(), PROJECT_FIELD_NAME);
        return this.getLast(changesToProjectField).map(projectFieldChange -> Long.valueOf(projectFieldChange.getFrom()));
    }

    private <T> Optional<T> getLast(List<T> list) {
        return list.isEmpty() ? Optional.empty() : Optional.of(list.get(list.size() - 1));
    }

    private boolean isIssueMoveEvent(Long eventTypeId) {
        return eventTypeId.equals(EventType.ISSUE_MOVED_ID);
    }
}

