/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment.conditions;

import com.atlassian.gadgets.dashboard.DashboardId;
import com.atlassian.gadgets.dashboard.spi.DashboardPermissionService;
import com.atlassian.jira.bc.portal.PortalPageService;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import java.util.Map;

public class ShowDashboardToolsMenuCondition
implements Condition {
    public static final String CONTEXT_KEY_DASHBOARD_ID = "dashboardId";
    private final DashboardPermissionService dashboardPermissionService;
    private final PortalPageService portalPageService;
    private final UserUtil userUtil;

    public ShowDashboardToolsMenuCondition(DashboardPermissionService dashboardPermissionService, PortalPageService portalPageService, UserUtil userUtil) {
        this.dashboardPermissionService = dashboardPermissionService;
        this.portalPageService = portalPageService;
        this.userUtil = userUtil;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        PortalPage defaultPortalPage = this.portalPageService.getSystemDefaultPortalPage();
        DashboardId dashboardId = (DashboardId)context.get(CONTEXT_KEY_DASHBOARD_ID);
        String username = (String)context.get("username");
        if (dashboardId != null && defaultPortalPage.getId().equals(Long.valueOf(dashboardId.value())) && this.dashboardPermissionService.isWritableBy(dashboardId, username)) {
            return false;
        }
        ApplicationUser user = this.userUtil.getUserByName(username);
        return user != null;
    }
}

