/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.userformat;

import com.atlassian.fugue.Option;
import com.atlassian.jira.plugin.profile.UserFormat;
import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang.StringUtils;

public class CachingUserFormat
implements UserFormat {
    private static final long MAX_CACHE_SIZE = 500L;
    private final UserFormat delegate;
    private final Cache<Key, Option<String>> cache;
    private static final Map<String, Object> EMPTY_PARAMS = new HashMap<String, Object>(0);
    @VisibleForTesting
    static final String ID_HOLDER_SIGNATURE = "{CACHING_CONTEXT_ID}";

    public CachingUserFormat(UserFormat delegate) {
        this.delegate = delegate;
        Map<String, Object> requestCache = JiraAuthenticationContextImpl.getRequestCache();
        Cache cache = (Cache)requestCache.get("jira.plugin.userformat.cache");
        if (cache == null) {
            cache = CacheBuilder.newBuilder().maximumSize(500L).build();
            requestCache.put("jira.plugin.userformat.cache", cache);
        }
        this.cache = cache;
    }

    public String format(String userkey, String id) {
        return this.format(userkey, id, EMPTY_PARAMS);
    }

    public String format(String userkey, String id, Map<String, Object> params) {
        Key cacheKey = new Key(userkey, this.delegate, params);
        try {
            return StringUtils.replace((String)this.formattedUserProfileFromCacheIfAny(cacheKey, userkey, params), (String)ID_HOLDER_SIGNATURE, (String)id);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    private String formattedUserProfileFromCacheIfAny(Key cacheKey, String userkey, Map<String, Object> params) throws ExecutionException {
        return (String)((Option)this.cache.get((Object)cacheKey, this.doRenderFormattedUser(userkey, params))).getOrNull();
    }

    private Callable<Option<String>> doRenderFormattedUser(final String userkey, final Map<String, Object> params) {
        return new Callable<Option<String>>(){

            @Override
            public Option<String> call() throws Exception {
                return Option.option((Object)CachingUserFormat.this.delegate.format(userkey, CachingUserFormat.ID_HOLDER_SIGNATURE, params));
            }
        };
    }

    @VisibleForTesting
    UserFormat getDelegate() {
        return this.delegate;
    }

    private static class Key {
        private final String userkey;
        private final Map<String, Object> contextParams;
        private final boolean paramsProvided;
        private final UserFormat userFormat;
        private int hashCode;

        private Key(String userkey, UserFormat userFormat, Map<String, Object> contextParams) {
            this.userkey = userkey;
            this.contextParams = contextParams;
            this.paramsProvided = contextParams != null;
            this.userFormat = userFormat;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.paramsProvided != key.paramsProvided) {
                return false;
            }
            if (this.userkey != null ? !this.userkey.equals(key.userkey) : key.userkey != null) {
                return false;
            }
            if (this.userFormat != null ? !this.userFormat.equals(key.userFormat) : key.userFormat != null) {
                return false;
            }
            return !(this.contextParams != null ? !this.contextParams.equals(key.contextParams) : key.contextParams != null);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                result = this.userkey != null ? this.userkey.hashCode() : 0;
                result = 31 * result + (this.contextParams != null ? this.contextParams.hashCode() : 0);
                result = 31 * result + (this.paramsProvided ? 1 : 0);
                this.hashCode = result = 31 * result + (this.userFormat != null ? this.userFormat.hashCode() : 0);
            }
            return result;
        }
    }
}

