/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.keyboardshortcut;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.plugin.keyboardshortcut.KeyboardShortcut;
import com.atlassian.jira.plugin.keyboardshortcut.KeyboardShortcutManager;
import com.atlassian.jira.plugin.keyboardshortcut.KeyboardShortcutModuleDescriptor;
import com.atlassian.jira.plugin.keyboardshortcut.PluginShortcuts;
import com.atlassian.jira.plugin.webfragment.DefaultWebFragmentContext;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.preferences.ExtendedPreferences;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.user.util.Users;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public class CachingKeyboardShortcutManager
implements KeyboardShortcutManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachingKeyboardShortcutManager.class);
    private static final String REST_PREFIX = "/rest/api/1.0/shortcuts/";
    private static final String REST_RESOURCE = "/shortcuts.js";
    private static final String REQUEST_CACHE_KEY = "keyboard.shortcuts.contexts";
    private final PluginShortcuts shortcuts = new PluginShortcuts();
    private final BuildUtilsInfo buildUtilsInfo;
    private final PluginAccessor pluginAccessor;
    private final WebResourceIntegration webResourceIntegration;
    private final JiraAuthenticationContext authenticationContext;
    private final UserPreferencesManager userPreferencesManager;

    public CachingKeyboardShortcutManager(BuildUtilsInfo buildUtilsInfo, PluginAccessor pluginAccessor, WebResourceIntegration webResourceIntegration, JiraAuthenticationContext authenticationContext, UserPreferencesManager userPreferencesManager) {
        this.buildUtilsInfo = buildUtilsInfo;
        this.pluginAccessor = pluginAccessor;
        this.webResourceIntegration = webResourceIntegration;
        this.authenticationContext = authenticationContext;
        this.userPreferencesManager = userPreferencesManager;
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        List descriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(KeyboardShortcutModuleDescriptor.class);
        this.shortcuts.reInit(descriptors);
    }

    public void registerShortcut(String pluginModuleKey, KeyboardShortcut shortcut) {
        this.shortcuts.register(pluginModuleKey, shortcut);
    }

    public void unregisterShortcut(String pluginModuleKey) {
        this.shortcuts.unregister(pluginModuleKey);
    }

    public List<KeyboardShortcut> getActiveShortcuts() {
        return this.listActiveShortcutsUniquePerContext(Collections.emptyMap());
    }

    public List<KeyboardShortcut> listActiveShortcutsUniquePerContext(final Map<String, Object> userContext) {
        Iterable filter = Iterables.filter(this.getAllShortcuts(), (Predicate)new Predicate<KeyboardShortcut>(){

            public boolean apply(KeyboardShortcut keyboardShortcut) {
                try {
                    return keyboardShortcut.shouldDisplay(userContext);
                }
                catch (RuntimeException e) {
                    LOGGER.warn("failed to evaluate the conditions of a keyboard shortcut: " + keyboardShortcut, (Throwable)e);
                    return false;
                }
            }
        });
        return this.eliminateShadowedShortcutsPerContext(Lists.newLinkedList((Iterable)filter));
    }

    public List<KeyboardShortcut> getAllShortcuts() {
        return this.shortcuts.getAll();
    }

    public void requireShortcutsForContext(KeyboardShortcutManager.Context context) {
        this.getRequiredContexts().add(context);
    }

    private List<KeyboardShortcut> eliminateShadowedShortcutsPerContext(List<KeyboardShortcut> keyboardShortcuts) {
        LinkedHashMap activeShortcuts = Maps.newLinkedHashMap();
        for (KeyboardShortcut addingShortcut : keyboardShortcuts) {
            ShortcutCacheKey addingKey = ShortcutCacheKey.makeCacheKey(addingShortcut);
            for (ShortcutCacheKey existingKeys : activeShortcuts.keySet()) {
                KeyboardShortcut existingShortcut = (KeyboardShortcut)activeShortcuts.get(existingKeys);
                if (!addingKey.conflictsWith(existingKeys)) continue;
                activeShortcuts.remove(existingKeys);
                if (!LOGGER.isDebugEnabled()) break;
                LOGGER.debug(String.format("Keyboard shortcut %s ('%s') is shadowed by %s ('%s') in context %s", addingShortcut.getDescriptionI18nKey(), addingShortcut.getShortcuts(), existingShortcut.getDescriptionI18nKey(), existingShortcut.getShortcuts(), existingShortcut.getContext()));
                break;
            }
            activeShortcuts.put(addingKey, addingShortcut);
        }
        return Lists.newArrayList(activeShortcuts.values());
    }

    private Set<KeyboardShortcutManager.Context> getRequiredContexts() {
        Map requestCache = this.webResourceIntegration.getRequestCache();
        LinkedHashSet requiredContexts = (LinkedHashSet)requestCache.get(REQUEST_CACHE_KEY);
        if (requiredContexts == null) {
            requiredContexts = new LinkedHashSet();
            requestCache.put(REQUEST_CACHE_KEY, requiredContexts);
        }
        return requiredContexts;
    }

    public String includeShortcuts() {
        UrlBuilder url = new UrlBuilder(this.createUrl());
        for (KeyboardShortcutManager.Context context : this.getRequiredContexts()) {
            url.addParameterUnsafe("context", context.toString());
        }
        return url.asUrlString();
    }

    private String createUrl() {
        MessageDigest messageDigest = this.getMessageDigest("MD5");
        if (messageDigest == null) {
            messageDigest = this.getMessageDigest("SHA");
        }
        if (messageDigest == null) {
            throw new RuntimeException("Unable to retrieve a valid message digest!");
        }
        messageDigest.update(this.getValueForHash().getBytes());
        byte[] digest = messageDigest.digest();
        BigInteger bigInt = new BigInteger(1, digest);
        String hash = bigInt.toString(16);
        return REST_PREFIX + this.buildUtilsInfo.getCurrentBuildNumber() + "/" + hash + REST_RESOURCE;
    }

    private MessageDigest getMessageDigest(String digestName) {
        try {
            return MessageDigest.getInstance(digestName);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    private String getValueForHash() {
        List<KeyboardShortcut> shortcuts = this.getAllShortcuts();
        Map<String, Object> context = this.getWebFragmentContext();
        StringBuilder sb = new StringBuilder();
        for (KeyboardShortcut shortcut : shortcuts) {
            sb.append(shortcut).append(shortcut.shouldDisplay(context));
        }
        return sb.toString();
    }

    Map<String, Object> getWebFragmentContext() {
        return DefaultWebFragmentContext.get();
    }

    public boolean isKeyboardShortcutsEnabled() {
        ApplicationUser user = this.authenticationContext.getUser();
        if (Users.isAnonymous((ApplicationUser)user)) {
            return true;
        }
        ExtendedPreferences userPrefs = this.userPreferencesManager.getExtendedPreferences(user);
        return !userPrefs.getBoolean("user.keyboard.shortcuts.disabled");
    }

    static final class ShortcutCacheKey {
        final KeyboardShortcutManager.Context context;
        final ImmutableSet<ImmutableList<String>> shortcuts;

        public static ShortcutCacheKey makeCacheKey(@Nonnull KeyboardShortcut shortcut) {
            Assertions.notNull((String)"shortcut", (Object)shortcut);
            return new ShortcutCacheKey(shortcut.getContext(), shortcut.getShortcuts());
        }

        private ShortcutCacheKey(KeyboardShortcutManager.Context context, Set<List<String>> shortcuts) {
            this.context = context;
            this.shortcuts = this.makeImmutable(shortcuts);
        }

        public boolean conflictsWith(ShortcutCacheKey that) {
            boolean contextEquals = Objects.equal((Object)this.context, (Object)that.context);
            if (contextEquals) {
                for (ImmutableList thisShortcut : this.shortcuts) {
                    String thisKeys = StringUtils.join((Iterable)thisShortcut, (String)"");
                    for (ImmutableList thatShortcut : that.shortcuts) {
                        String thatKeys = StringUtils.join((Iterable)thatShortcut, (String)"");
                        if (!thisKeys.startsWith(thatKeys) && !thatKeys.startsWith(thisKeys)) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ShortcutCacheKey that = (ShortcutCacheKey)o;
            if (this.context != that.context) {
                return false;
            }
            return this.shortcuts.equals(that.shortcuts);
        }

        public int hashCode() {
            int result = this.context.hashCode();
            result = 31 * result + this.shortcuts.hashCode();
            return result;
        }

        private ImmutableSet<ImmutableList<String>> makeImmutable(Set<List<String>> keys) {
            return ImmutableSet.copyOf((Iterable)Iterables.transform(keys, (Function)new Function<List<String>, ImmutableList<String>>(){

                public ImmutableList<String> apply(@Nullable List<String> input) {
                    return ImmutableList.copyOf(input);
                }
            }));
        }
    }
}

