/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.icon;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.icon.IconOwningObjectId;
import com.atlassian.jira.icon.IconType;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.plugin.icon.IconTypePolicy;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectIconTypePolicy
implements IconTypePolicy {
    private final GlobalPermissionManager globalPermissionManager;
    private final PermissionManager permissionManager;
    private final ProjectService projectService;
    private final ProjectManager projectManager;
    private static final Logger log = LoggerFactory.getLogger(ProjectIconTypePolicy.class);

    public ProjectIconTypePolicy(GlobalPermissionManager globalPermissionManager, PermissionManager permissionManager, ProjectService projectService, ProjectManager projectManager) {
        this.globalPermissionManager = globalPermissionManager;
        this.permissionManager = permissionManager;
        this.projectService = projectService;
        this.projectManager = projectManager;
    }

    public boolean userCanView(@Nullable ApplicationUser remoteUser, @Nonnull Avatar icon) {
        String owningObjectID = icon.getOwner();
        boolean result = false;
        if (!icon.getIconType().equals((Object)IconType.PROJECT_ICON_TYPE)) {
            result = false;
        } else if (icon.isSystemAvatar()) {
            result = true;
        } else if (owningObjectID == null) {
            result = false;
        } else {
            long owningProjectId;
            try {
                owningProjectId = Long.parseLong(owningObjectID);
            }
            catch (NumberFormatException e) {
                log.error("Could not parse project ID " + owningObjectID);
                return false;
            }
            Project project = this.projectManager.getProjectObj(Long.valueOf(owningProjectId));
            result = null != project;
            boolean bl = result = result && this.hasUserPermissionToProject(remoteUser, project);
        }
        if (!result && log.isDebugEnabled()) {
            try {
                log.debug("User " + remoteUser.getKey() + " did not have permission to view icon for project id=" + owningObjectID);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    private boolean hasUserPermissionToProject(ApplicationUser remoteUser, Project project) {
        boolean isAdmin = this.permissionManager.hasPermission(0, remoteUser);
        boolean isProjectAdmin = this.permissionManager.hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, project, remoteUser);
        boolean hasBrowseProject = this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, project, remoteUser);
        return hasBrowseProject || isProjectAdmin || isAdmin;
    }

    public boolean userCanDelete(@Nullable ApplicationUser remoteUser, @Nonnull Avatar icon) {
        if (remoteUser == null) {
            return false;
        }
        String owningObjectID = icon.getOwner();
        if (owningObjectID == null) {
            return false;
        }
        Project project = this.projectManager.getProjectObj(Long.valueOf(Long.parseLong(owningObjectID)));
        if (project == null) {
            return false;
        }
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, remoteUser) || this.permissionManager.hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, project, remoteUser);
    }

    public boolean userCanCreateFor(@Nullable ApplicationUser remoteUser, @Nonnull IconOwningObjectId owningObjectId) {
        long owningProjectId;
        if (remoteUser == null) {
            return false;
        }
        try {
            owningProjectId = Long.parseLong(owningObjectId.getId());
        }
        catch (Exception x) {
            log.error("Could not map " + owningObjectId.getId() + " to a project.");
            return false;
        }
        ProjectService.GetProjectResult getProjectResult = this.projectService.getProjectByIdForAction(remoteUser, Long.valueOf(owningProjectId), ProjectAction.EDIT_PROJECT_CONFIG);
        return getProjectResult.isValid();
    }
}

