/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin;

import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.plugin.BootstrapPluginDirectoryLoaderFactory;
import com.atlassian.jira.plugin.PluginFactoryAndLoaderRegistrar;
import com.atlassian.jira.plugin.PluginLoaderFactory;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.plugin.factories.PluginFactory;
import com.atlassian.plugin.loaders.PluginLoader;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapPluginLoaderFactory
implements PluginLoaderFactory {
    private static final Logger log = LoggerFactory.getLogger(BootstrapPluginLoaderFactory.class);
    private final PluginFactoryAndLoaderRegistrar pluginFactoryAndLoaderRegistrar;
    private final BootstrapPluginDirectoryLoaderFactory bootstrapPluginDirectoryLoaderFactory;

    public BootstrapPluginLoaderFactory(PluginFactoryAndLoaderRegistrar pluginFactoryAndLoaderRegistrar, BootstrapPluginDirectoryLoaderFactory bootstrapPluginDirectoryLoaderFactory) {
        this.pluginFactoryAndLoaderRegistrar = pluginFactoryAndLoaderRegistrar;
        this.bootstrapPluginDirectoryLoaderFactory = bootstrapPluginDirectoryLoaderFactory;
    }

    @Override
    public List<PluginLoader> getPluginLoaders() {
        ArrayList pluginWhitelist = Lists.newArrayList((Object[])new Pattern[]{Pattern.compile("jquery-[0-9]+(?:\\.[0-9])+\\.jar"), Pattern.compile("auiplugin-[0-9.]+.*\\.jar"), Pattern.compile("jira-(?:core-)?language-pack-.*\\.jar"), Pattern.compile("jira-languages-.*\\.jar"), Pattern.compile("org.apache.servicemix.bundles.javax-inject-.*\\.jar"), Pattern.compile("soy-template-plugin-.*\\.jar"), Pattern.compile("issue-status-plugin-.*\\.jar"), Pattern.compile("less-transformer-plugin-.*\\.jar"), Pattern.compile("jira-less-integration-.*\\.jar"), Pattern.compile("jslibs-.*\\.jar")});
        List<PluginFactory> pluginFactories = this.pluginFactoryAndLoaderRegistrar.getDefaultPluginFactories(pluginWhitelist);
        CollectionBuilder pluginLoaderBuilder = CollectionBuilder.newBuilder();
        pluginLoaderBuilder.addAll(this.pluginFactoryAndLoaderRegistrar.getBootstrapSystemPluginLoaders());
        if (JiraSystemProperties.isBundledPluginsDisabled()) {
            log.warn("Bundled plugins have been disabled. Removing bundled plugin loader.");
        } else {
            pluginLoaderBuilder.add((Object)this.pluginFactoryAndLoaderRegistrar.getBundledPluginsLoader(pluginFactories));
        }
        pluginLoaderBuilder.add((Object)this.bootstrapPluginDirectoryLoaderFactory.getDirectoryPluginLoader(pluginFactories));
        return pluginLoaderBuilder.asList();
    }
}

