/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.permission.data;

import com.atlassian.fugue.Option;
import com.atlassian.jira.permission.JiraPermissionHolderType;
import com.atlassian.jira.permission.PermissionHolderType;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CustomPermissionHolderType
implements PermissionHolderType {
    private final String key;
    private final boolean requiresParameter;

    private CustomPermissionHolderType(String key, boolean requiresParameter) {
        this.key = key;
        this.requiresParameter = requiresParameter;
    }

    public static PermissionHolderType permissionHolderType(@Nonnull String key, @Nullable String parameter) {
        Option jiraHolderType = JiraPermissionHolderType.fromKey((String)key, (String)parameter);
        if (jiraHolderType.isDefined()) {
            return (PermissionHolderType)jiraHolderType.get();
        }
        return new CustomPermissionHolderType(key, !Strings.isNullOrEmpty((String)parameter));
    }

    public String getKey() {
        return this.key;
    }

    public boolean requiresParameter() {
        return this.requiresParameter;
    }

    public String toString() {
        return this.key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomPermissionHolderType that = (CustomPermissionHolderType)o;
        return Objects.equal((Object)this.key, (Object)that.key) && Objects.equal((Object)this.requiresParameter, (Object)that.requiresParameter);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.key, this.requiresParameter});
    }
}

