/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.permission;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.association.NodeAssociationStore;
import com.atlassian.jira.cache.SwitchingCacheFactory;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.permission.DefaultPermissionSchemeManager;
import com.atlassian.jira.permission.LegacyProjectPermissionKeyMapping;
import com.atlassian.jira.permission.PermissionContext;
import com.atlassian.jira.permission.PermissionContextFactory;
import com.atlassian.jira.permission.PermissionTypeManager;
import com.atlassian.jira.permission.WorkflowPermission;
import com.atlassian.jira.permission.WorkflowPermissionFactory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.scheme.SchemeFactory;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowBasedPermissionSchemeManager
extends DefaultPermissionSchemeManager
implements Startable {
    private static final Logger log = LoggerFactory.getLogger(WorkflowBasedPermissionSchemeManager.class);
    private SubTaskManager subTaskManager;
    private WorkflowPermissionFactory workflowPermissionFactory;
    private PermissionContextFactory permissionContextFactory;
    private final EventPublisher eventPublisher;

    public WorkflowBasedPermissionSchemeManager(ProjectManager projectManager, PermissionTypeManager permissionTypeManager, WorkflowPermissionFactory workflowPermissionFactory, PermissionContextFactory permissionContextFactory, OfBizDelegator ofBizDelegator, SchemeFactory schemeFactory, EventPublisher eventPublisher, NodeAssociationStore nodeAssociationStore, GroupManager groupManager, SwitchingCacheFactory cacheFactory) {
        super(projectManager, permissionTypeManager, permissionContextFactory, ofBizDelegator, schemeFactory, nodeAssociationStore, groupManager, eventPublisher, cacheFactory);
        this.workflowPermissionFactory = workflowPermissionFactory;
        this.permissionContextFactory = permissionContextFactory;
        this.eventPublisher = eventPublisher;
        this.subTaskManager = ComponentAccessor.getSubTaskManager();
    }

    @Override
    public void start() throws Exception {
        super.start();
        this.eventPublisher.register((Object)this);
    }

    @Override
    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        super.onClearCache(event);
    }

    @Override
    public Collection<ApplicationUser> getUsers(Long permissionId, PermissionContext ctx) {
        ProjectPermissionKey permissionKey = LegacyProjectPermissionKeyMapping.getKey(permissionId);
        return this.getUsers(permissionKey, ctx);
    }

    @Override
    public Collection<ApplicationUser> getUsers(@Nonnull ProjectPermissionKey permissionKey, @Nonnull PermissionContext ctx) {
        Collection<ApplicationUser> users = super.getUsers(permissionKey, ctx);
        if (permissionKey == null) {
            return users;
        }
        if (ctx.hasIssuePermissions()) {
            List<WorkflowPermission> workflowPerms = this.workflowPermissionFactory.getWorkflowPermissions(ctx, permissionKey, false);
            if (this.subTaskManager.isSubTasksEnabled() && ctx.getIssue().getParentObject() != null) {
                PermissionContext parentCtx = this.permissionContextFactory.getPermissionContext(ctx.getIssue().getParentObject());
                workflowPerms.addAll(this.workflowPermissionFactory.getWorkflowPermissions(parentCtx, permissionKey, true));
            }
            if (workflowPerms.size() > 0) {
                HashSet<ApplicationUser> allowedUsers = new HashSet<ApplicationUser>(users.size());
                for (WorkflowPermission perm : workflowPerms) {
                    try {
                        Set<ApplicationUser> newUsers = perm.getUsers(ctx);
                        log.info(perm + " added users: " + this.listUsers(newUsers));
                        allowedUsers.addAll(newUsers);
                    }
                    catch (IllegalArgumentException e) {
                        log.error("Error with workflow permission" + perm + ": " + e.getMessage(), (Throwable)e);
                        throw new RuntimeException("Error with workflow permission " + perm + ": " + e.getMessage());
                    }
                }
                log.info("Retaining " + this.listUsers(allowedUsers) + " of " + this.listUsers(users));
                users.retainAll(allowedUsers);
            }
        }
        return users;
    }

    private String listUsers(Collection newUsers) {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        Iterator iterator = newUsers.iterator();
        while (iterator.hasNext()) {
            ApplicationUser user = (ApplicationUser)iterator.next();
            buf.append(user.getName());
            if (!iterator.hasNext()) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }
}

