/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ofbiz;

import com.atlassian.instrumentation.operations.OpTimer;
import com.atlassian.jira.instrumentation.Instrumentation;
import com.atlassian.jira.instrumentation.InstrumentationName;
import com.atlassian.jira.ofbiz.JiraSQLInterceptorFactory;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.ofbiz.core.entity.jdbc.interceptors.connection.ConnectionPoolState;
import org.ofbiz.core.entity.jdbc.interceptors.connection.SQLConnectionInterceptor;

public class InstrumentedSQLInterceptor
implements SQLConnectionInterceptor {
    private OpTimer sqlTimer;
    private OpTimer connectionTimer;

    public void onConnectionTaken(Connection connection, ConnectionPoolState connectionPoolState) {
        Instrumentation.pullGauge(InstrumentationName.DB_CONNECTIONS_BORROWED).incrementAndGet();
        this.connectionTimer = Instrumentation.pullTimer(InstrumentationName.DB_CONNECTIONS);
    }

    public void onConnectionReplaced(Connection connection, ConnectionPoolState connectionPoolState) {
        this.connectionTimer.end();
        Instrumentation.pullGauge(InstrumentationName.DB_CONNECTIONS_BORROWED).decrementAndGet();
    }

    public void beforeExecution(String sql, List<String> params, Statement statement) {
        this.sqlTimer = JiraSQLInterceptorFactory.isMutatingSQL(sql) ? Instrumentation.pullTimer(InstrumentationName.DB_WRITES) : Instrumentation.pullTimer(InstrumentationName.DB_READS);
    }

    public void afterSuccessfulExecution(String sql, List<String> params, Statement statement, ResultSet resultSet, int i) {
        this.sqlTimer.end();
    }

    public void onException(String sql, List<String> params, Statement statement, SQLException e) {
        this.sqlTimer.end();
    }
}

