/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.memoryinspector;

import com.google.common.base.Objects;
import org.apache.commons.lang.StringUtils;

public class ThreadInfo {
    public static final String SYSTEM_CLASS_LOADER_NAME = "<system>";
    public static final String UNKNOWN_CLASS_LOADER_NAME = "<?>";
    public static final String UNKNOWN_GROUP_NAME = "<?>";
    private final String threadClassName;
    private final String threadName;
    private final String threadGroupName;
    private final String classLoaderClassName;
    private final Thread thread;
    private final Thread.State state;

    public ThreadInfo(Thread thread) {
        this.thread = thread;
        this.threadClassName = StringUtils.defaultString((String)thread.getClass().getCanonicalName());
        this.threadName = StringUtils.defaultString((String)thread.getName());
        ThreadGroup threadGroup = thread.getThreadGroup();
        this.threadGroupName = StringUtils.defaultString((String)(threadGroup == null ? "<?>" : threadGroup.getName()));
        ClassLoader contextClassLoader = thread.getContextClassLoader();
        this.classLoaderClassName = StringUtils.defaultString((String)(contextClassLoader == null ? "<?>" : contextClassLoader.getClass().getCanonicalName()), (String)SYSTEM_CLASS_LOADER_NAME);
        this.state = thread.getState();
    }

    public ThreadInfo(String threadClassName, String threadName, String threadGroupName, String classLoaderClassName, Thread thread) {
        this.threadClassName = threadClassName;
        this.threadName = threadName;
        this.threadGroupName = threadGroupName;
        this.classLoaderClassName = classLoaderClassName;
        this.thread = thread;
        this.state = null;
    }

    public String getThreadClassName() {
        return this.threadClassName;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public String getThreadGroupName() {
        return this.threadGroupName;
    }

    public Thread getThread() {
        return this.thread;
    }

    public String getClassLoaderClassName() {
        return this.classLoaderClassName;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.threadClassName, this.threadName, this.threadGroupName, this.classLoaderClassName, this.thread});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ThreadInfo other = (ThreadInfo)obj;
        return Objects.equal((Object)this.threadClassName, (Object)other.threadClassName) && Objects.equal((Object)this.threadName, (Object)other.threadName) && Objects.equal((Object)this.threadGroupName, (Object)other.threadGroupName) && Objects.equal((Object)this.classLoaderClassName, (Object)other.classLoaderClassName) && Objects.equal((Object)this.thread, (Object)other.thread);
    }

    public String toString() {
        return "ThreadInfo{threadClassName='" + this.threadClassName + '\'' + ", threadName='" + this.threadName + '\'' + ", threadGroupName='" + this.threadGroupName + '\'' + ", classLoaderClassName='" + this.classLoaderClassName + '\'' + ", thread=" + this.thread + ", state=" + (Object)((Object)this.state) + '}';
    }
}

