/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.jira.cluster.logging.LoggingManager;
import com.atlassian.jira.mail.MailLoggingManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.action.admin.mail.LogPrintStream;
import com.atlassian.mail.server.MailServer;
import com.atlassian.mail.server.MailServerConfigurationHandler;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.PopMailServer;
import com.atlassian.mail.server.SMTPMailServer;
import java.io.PrintStream;
import java.util.regex.Pattern;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import org.apache.log4j.spi.LoggerFactory;

public class DefaultMailLoggingManager
implements MailLoggingManager {
    private static final Logger outgoingMailLogger = Logger.getLogger((String)"com.atlassian.mail.outgoing");
    private static final Logger incomingMailLogger = Logger.getLogger((String)"com.atlassian.mail.incoming");
    private final LoggingManager loggingManager;

    public DefaultMailLoggingManager(MailServerManager mailServerManager, LoggingManager loggingManager) {
        this.loggingManager = loggingManager;
        mailServerManager.setMailServerConfigurationHandler(new MailServerConfigurationHandler(){

            public void configureMailServer(MailServer mailServer) {
                DefaultMailLoggingManager.this.configureLogging(mailServer);
            }
        });
    }

    public void configureLogging(MailServer mailServer) {
        if (mailServer instanceof SMTPMailServer) {
            outgoingMailLogger.trace((Object)("Configuring SMTPMailServer [" + mailServer + "]"));
            SMTPMailServer smtpMailServer = (SMTPMailServer)mailServer;
            smtpMailServer.setDebugStream((PrintStream)new PasswordFilteringLogPrintStream(mailServer.getPassword(), outgoingMailLogger));
            mailServer.setDebug(this.getOutgoingMailLoggingLevel() == Level.DEBUG);
            mailServer.setLogger(outgoingMailLogger);
        } else if (mailServer instanceof PopMailServer) {
            incomingMailLogger.trace((Object)("Configuring PopMailServer [" + mailServer + "]"));
            mailServer.setDebug(this.getIncomingMailLoggingLevel() == Level.DEBUG);
            mailServer.setDebugStream((PrintStream)new PasswordFilteringLogPrintStream(mailServer.getPassword(), incomingMailLogger));
            mailServer.setLogger(incomingMailLogger);
        }
        MDC.put((String)"jira.mailserver", (Object)mailServer.getName());
    }

    public Level getOutgoingMailLoggingLevel() {
        return outgoingMailLogger.getEffectiveLevel();
    }

    public Level getIncomingMailLoggingLevel() {
        return incomingMailLogger.getEffectiveLevel();
    }

    public void setOutgoingMailLoggingLevel(Level loggingLevel) {
        Assertions.notNull((String)"LoggingLevel cannot be null", (Object)loggingLevel);
        this.loggingManager.setLogLevel(outgoingMailLogger, loggingLevel);
    }

    public void setIncomingMailLoggingLevel(Level loggingLevel) {
        Assertions.notNull((String)"LoggingLevel cannot be null", (Object)loggingLevel);
        this.loggingManager.setLogLevel(incomingMailLogger, loggingLevel);
    }

    public Logger getOutgoingMailLogger() {
        return outgoingMailLogger;
    }

    public Logger getIncomingMailLogger() {
        return incomingMailLogger;
    }

    public Logger getIncomingMailChildLogger(String subname) {
        String loggerName = incomingMailLogger.getName() + "." + subname;
        return LogManager.getLogger((String)loggerName, (LoggerFactory)new NotChangeableLogLevelLoggerFactory());
    }

    public boolean isMailRelatedLogger(Logger logger) {
        String name = logger.getName();
        return name != null && name.startsWith("com.atlassian.mail");
    }

    private static class NotChangeableLogLevelLoggerFactory
    implements LoggerFactory {
        private NotChangeableLogLevelLoggerFactory() {
        }

        public Logger makeNewLoggerInstance(String name) {
            return new Logger(name){

                public void setLevel(Level level) {
                }
            };
        }
    }

    static class PasswordFilteringLogPrintStream
    extends LogPrintStream {
        private final String password;
        private final Pattern replacePattern;

        public PasswordFilteringLogPrintStream(String password, Logger logger) {
            super(logger, Level.DEBUG);
            this.password = password;
            this.replacePattern = password != null ? Pattern.compile("(.*PASS.*?[ \"]|.*LOGIN.*?[ \"])" + Pattern.quote(password)) : null;
        }

        @Override
        public String processLine(String s) {
            if (s != null && this.password != null && this.password.length() > 2) {
                s = this.replacePattern.matcher(s).replaceAll("$1<hidden password>");
            }
            return s;
        }
    }
}

