/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.license;

import com.atlassian.annotations.Internal;
import com.atlassian.core.util.Clock;
import com.atlassian.extras.api.AtlassianLicense;
import com.atlassian.extras.api.LicenseEdition;
import com.atlassian.extras.api.LicenseException;
import com.atlassian.extras.api.LicenseManager;
import com.atlassian.extras.api.Product;
import com.atlassian.extras.api.ProductLicense;
import com.atlassian.extras.api.jira.JiraLicense;
import com.atlassian.extras.common.util.LicenseProperties;
import com.atlassian.extras.core.AtlassianLicenseFactory;
import com.atlassian.extras.core.DefaultAtlassianLicenseFactory;
import com.atlassian.extras.core.DefaultLicenseManager;
import com.atlassian.extras.core.DefaultProductLicense;
import com.atlassian.extras.core.ProductLicenseFactory;
import com.atlassian.extras.core.jira.JiraProductLicenseFactory;
import com.atlassian.extras.decoder.api.DelegatingLicenseDecoder;
import com.atlassian.extras.decoder.api.LicenseDecoder;
import com.atlassian.extras.decoder.v1.Version1LicenseDecoder;
import com.atlassian.extras.decoder.v2.Version2LicenseDecoder;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.license.DefaultLicenseDetails;
import com.atlassian.jira.license.DefaultLicensedApplications;
import com.atlassian.jira.license.JiraProductLicense;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.license.LicenseDetailsFactory;
import com.atlassian.jira.license.SubscriptionLicenseDetails;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.util.ExternalLinkUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class LicenseDetailsFactoryImpl
implements LicenseDetailsFactory {
    private final ApplicationProperties applicationProperties;
    private final ExternalLinkUtil externalLinkUtil;
    private final BuildUtilsInfo buildUtilsInfo;
    private final I18nHelper.BeanFactory i18nFactory;
    private final DateTimeFormatter dateTimeFormatter;
    private final Clock clock;

    public LicenseDetailsFactoryImpl(ApplicationProperties applicationProperties, ExternalLinkUtil externalLinkUtil, BuildUtilsInfo buildUtilsInfo, I18nHelper.BeanFactory i18Factory, DateTimeFormatter dateTimeFormatter, Clock clock) {
        this.applicationProperties = applicationProperties;
        this.externalLinkUtil = externalLinkUtil;
        this.buildUtilsInfo = buildUtilsInfo;
        this.i18nFactory = i18Factory;
        this.dateTimeFormatter = dateTimeFormatter;
        this.clock = clock;
    }

    @Override
    @Nonnull
    public LicenseDetails getLicense(@Nonnull String licenseString) throws LicenseException {
        JiraProductLicense jiraLicense = JiraProductLicenseManager.INSTANCE.getProductLicense(licenseString);
        if (DefaultLicenseDetails.isEnterpriseSubscriptionLicense(jiraLicense)) {
            return new SubscriptionLicenseDetails(jiraLicense, licenseString, this.applicationProperties, this.externalLinkUtil, this.buildUtilsInfo, this.i18nFactory, this.dateTimeFormatter, this.clock);
        }
        return new DefaultLicenseDetails(jiraLicense, licenseString, this.applicationProperties, this.externalLinkUtil, this.buildUtilsInfo, this.i18nFactory, this.dateTimeFormatter, this.clock);
    }

    @Override
    public boolean isDecodeable(@Nonnull String licenseString) {
        try {
            JiraProductLicense productLicense = JiraProductLicenseManager.INSTANCE.getProductLicense(licenseString);
            return !productLicense.getApplications().getKeys().isEmpty();
        }
        catch (LicenseException e) {
            return false;
        }
    }

    private static class JiraApplicationLicense
    extends DefaultProductLicense
    implements JiraLicense {
        private JiraApplicationLicense(Product product, LicenseProperties licenseProperties) {
            super(product, licenseProperties);
        }

        public LicenseEdition getLicenseEdition() {
            return LicenseEdition.ENTERPRISE;
        }

        public boolean isClusteringEnabled() {
            return DefaultLicenseDetails.isDataCenterLicense(this);
        }
    }

    private static class ServiceDeskPluginLicenseFactory
    extends JiraProductLicenseFactory {
        private static final String ACTIVE_SD70 = DefaultLicensedApplications.JIRA_PRODUCT_NAMESPACE + ApplicationKeys.SERVICE_DESK + "." + "active";
        private static final Product PRODUCT = new Product("JIRA Service Desk (Legacy)", "com.atlassian.servicedesk", true);

        private ServiceDeskPluginLicenseFactory() {
        }

        public ProductLicense getLicenseInternal(Product product, LicenseProperties licenseProperties) {
            if (this.hasLicense(product, licenseProperties)) {
                return new JiraApplicationLicense(product, licenseProperties);
            }
            throw new LicenseException("Could not create JIRA license for " + product);
        }

        public boolean hasLicense(Product product, LicenseProperties licenseProperties) {
            return !licenseProperties.getBoolean(ACTIVE_SD70) && licenseProperties.getBoolean("com.atlassian.servicedesk.active");
        }
    }

    private static class JiraApplicationLicenseFactory
    extends JiraProductLicenseFactory {
        private static final Product PRODUCT = new Product("JIRA Apps", "jira");

        private JiraApplicationLicenseFactory() {
        }

        public ProductLicense getLicenseInternal(Product product, LicenseProperties licenseProperties) {
            if (this.hasLicense(product, licenseProperties)) {
                return new JiraApplicationLicense(product, licenseProperties);
            }
            throw new LicenseException("Could not create JIRA license for " + product);
        }

        public boolean hasLicense(Product product, LicenseProperties licenseProperties) {
            Map propertiesWithActiveFlag = licenseProperties.getPropertiesEndingWith("active");
            for (Map.Entry entry : propertiesWithActiveFlag.entrySet()) {
                if (!((String)entry.getKey()).startsWith(DefaultLicensedApplications.JIRA_PRODUCT_NAMESPACE) || !((String)entry.getValue()).equals("true")) continue;
                return true;
            }
            return false;
        }
    }

    @Internal
    public static class JiraProductLicenseManager {
        public static final JiraProductLicenseManager INSTANCE = new JiraProductLicenseManager();
        private final ImmutableMap<Product, ProductLicenseFactory> factories;
        private final LicenseManager licenseManager;
        private final LicenseDecoder licenseDecoder;

        private JiraProductLicenseManager() {
            ImmutableMap<Product, ProductLicenseFactory> factories = JiraProductLicenseManager.getCompatibleJiraProductFactories();
            DefaultAtlassianLicenseFactory atlassianLicenseFactory = new DefaultAtlassianLicenseFactory(factories);
            this.factories = factories;
            this.licenseDecoder = new DelegatingLicenseDecoder((List)ImmutableList.of((Object)new Version2LicenseDecoder(), (Object)new Version1LicenseDecoder()));
            this.licenseManager = new DefaultLicenseManager(this.licenseDecoder, (AtlassianLicenseFactory)atlassianLicenseFactory);
        }

        @Nonnull
        @Internal
        public JiraProductLicense getProductLicense(@Nonnull String licenseKey) throws LicenseException {
            if (StringUtils.isBlank((String)licenseKey)) {
                throw new LicenseException("Null or blank license");
            }
            AtlassianLicense atlassianLicense = this.licenseManager.getLicense(licenseKey);
            for (Product product : this.factories.keySet()) {
                ProductLicense productLicense = atlassianLicense.getProductLicense(product);
                if (!(productLicense instanceof JiraLicense)) continue;
                JiraLicense jiraLicense = (JiraLicense)productLicense;
                DefaultLicensedApplications licensedApplications = new DefaultLicensedApplications(licenseKey, this.licenseDecoder);
                if (licensedApplications.getKeys().isEmpty()) continue;
                return new JiraProductLicense(licensedApplications, jiraLicense);
            }
            throw new LicenseException("Invalid license key. Please contact Atlassian Support.");
        }

        private static ImmutableMap<Product, ProductLicenseFactory> getCompatibleJiraProductFactories() {
            return ImmutableMap.of((Object)Product.JIRA, (Object)new JiraProductLicenseFactory(), (Object)JiraApplicationLicenseFactory.PRODUCT, (Object)((Object)new JiraApplicationLicenseFactory()), (Object)ServiceDeskPluginLicenseFactory.PRODUCT, (Object)((Object)new ServiceDeskPluginLicenseFactory()));
        }
    }
}

