/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.license;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.extras.api.LicenseException;
import com.atlassian.fugue.Option;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.license.Jira6xServiceDeskPluginEncodedLicenseSupplier;
import com.atlassian.jira.license.JiraProductLicense;
import com.atlassian.jira.license.LicenseDetailsFactoryImpl;
import com.atlassian.jira.license.MultiLicenseStore;
import com.atlassian.jira.license.MultiLicenseStoreImpl;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;

public class LegacyMultiLicenseStore
implements MultiLicenseStore {
    private final MultiLicenseStore delegate;
    private final ApplicationProperties applicationProperties;
    private final Jira6xServiceDeskPluginEncodedLicenseSupplier sdSupplier;

    @Inject
    public LegacyMultiLicenseStore(MultiLicenseStoreImpl delegate, ApplicationProperties applicationProperties) {
        this((MultiLicenseStore)delegate, applicationProperties);
    }

    @VisibleForTesting
    LegacyMultiLicenseStore(MultiLicenseStore delegate, ApplicationProperties applicationProperties) {
        this.applicationProperties = (ApplicationProperties)Assertions.notNull((String)"applicationProperties", (Object)applicationProperties);
        this.delegate = (MultiLicenseStore)Assertions.notNull((String)"delegate", (Object)delegate);
        this.sdSupplier = new Jira6xServiceDeskPluginEncodedLicenseSupplier(applicationProperties);
    }

    @Override
    @Nonnull
    public Iterable<String> retrieve() {
        try {
            Licenses parsedLicenses = new Licenses(Iterables.transform(this.delegate.retrieve(), x$0 -> new License((String)x$0)));
            if (parsedLicenses.isEmpty()) {
                parsedLicenses = parsedLicenses.addLicense((Option<License>)this.retrieveOldLicense());
            }
            return parsedLicenses.addLicense((Option<License>)this.retrieveOldSdLicense()).toLicenseStrings();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public void store(@Nonnull Iterable<String> licenses) {
        if (Iterables.isEmpty(licenses)) {
            throw new IllegalArgumentException("You must store at least one license.");
        }
        if (Iterables.any(licenses, (Predicate)Predicates.isNull())) {
            throw new IllegalArgumentException("You cannot store null licenses - no changes have been made to licenses.");
        }
        this.sdSupplier.moveToUpgradeStore();
        this.clearOldLicense();
        this.delegate.store(licenses);
    }

    @Override
    public String retrieveServerId() {
        return this.delegate.retrieveServerId();
    }

    @Override
    public void storeServerId(String serverId) {
        this.delegate.storeServerId(serverId);
    }

    @Override
    public void resetOldBuildConfirmation() {
        this.delegate.resetOldBuildConfirmation();
    }

    @Override
    public void confirmProceedUnderEvaluationTerms(String userName) {
        this.delegate.confirmProceedUnderEvaluationTerms(userName);
    }

    @Override
    public void clear() {
        this.sdSupplier.moveToUpgradeStore();
        this.clearOldLicense();
        this.delegate.clear();
    }

    private void clearOldLicense() {
        this.applicationProperties.setText("License20", null);
    }

    private Option<License> retrieveOldLicense() {
        return this.retrieveOldLicenseString().map(x$0 -> new License((String)x$0));
    }

    private Option<String> retrieveOldLicenseString() {
        return Option.option((Object)this.applicationProperties.getText("License20"));
    }

    private Option<License> retrieveOldSdLicense() {
        return this.sdSupplier.get().map(x$0 -> new License((String)x$0)).filter(license -> ((License)license).isLicensed(ApplicationKeys.SERVICE_DESK));
    }

    private static class Licenses {
        private final ImmutableSet<License> licenses;
        private final ImmutableSet<ApplicationKey> applicationKeys;

        Licenses(Iterable<? extends License> licenses) {
            Assertions.containsNoNulls((String)"licenses", licenses);
            HashMap<ApplicationKey, License> index = new HashMap<ApplicationKey, License>();
            for (License license : licenses) {
                for (ApplicationKey applicationKey : license.applicationKeys()) {
                    License oldLicense = index.put(applicationKey, license);
                    if (oldLicense == null || oldLicense.equals(license)) continue;
                    throw new IllegalArgumentException(String.format("More than once license contains access to '%s'. The licenses are: %s and %s.", applicationKey, oldLicense, license));
                }
            }
            this.applicationKeys = ImmutableSet.copyOf(index.keySet());
            this.licenses = ImmutableSet.copyOf(licenses);
        }

        private Licenses(ImmutableSet<License> licenses, ImmutableSet<ApplicationKey> applicationKeys) {
            this.licenses = licenses;
            this.applicationKeys = applicationKeys;
        }

        private Licenses addLicense(Option<License> licenseOption) {
            Assertions.notNull((String)"licenseOption", licenseOption);
            if (licenseOption.isEmpty()) {
                return this;
            }
            License license = (License)licenseOption.get();
            if (!Sets.intersection((Set)license.applicationKeys(), this.applicationKeys).isEmpty()) {
                return this;
            }
            ImmutableSet licenses = ImmutableSet.builder().addAll(this.licenses).add((Object)license).build();
            ImmutableSet keys = ImmutableSet.builder().addAll(this.applicationKeys).addAll((Iterable)license.applicationKeys()).build();
            return new Licenses((ImmutableSet<License>)licenses, (ImmutableSet<ApplicationKey>)keys);
        }

        private List<String> toLicenseStrings() {
            return (List)this.licenses.stream().map(rec$ -> ((License)rec$).licenseString()).collect(CollectorsUtil.toImmutableList());
        }

        private boolean isEmpty() {
            return this.licenses.isEmpty();
        }

        public String toString() {
            return this.licenses.toString();
        }
    }

    private static final class License {
        private static final LicenseDetailsFactoryImpl.JiraProductLicenseManager FACTORY = LicenseDetailsFactoryImpl.JiraProductLicenseManager.INSTANCE;
        private final JiraProductLicense productLicense;
        private final String licenseString;

        private License(String licenseString) {
            this.licenseString = (String)Assertions.notNull((String)"licenseString", (Object)licenseString);
            try {
                this.productLicense = FACTORY.getProductLicense(licenseString);
            }
            catch (LicenseException e) {
                String msg = String.format("Unable to parse license: %s", License.abbreviate(licenseString));
                throw new IllegalArgumentException(msg, e);
            }
        }

        private String licenseString() {
            return this.licenseString;
        }

        private boolean isLicensed(ApplicationKey key) {
            return this.productLicense.getApplications().getKeys().contains(key);
        }

        private Set<ApplicationKey> applicationKeys() {
            return this.productLicense.getApplications().getKeys();
        }

        private String abbreviatedLicenseString() {
            return License.abbreviate(this.licenseString);
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            License license = (License)o;
            return this.licenseString.equals(license.licenseString);
        }

        public int hashCode() {
            return this.licenseString.hashCode();
        }

        public String toString() {
            return String.format("License for %s: %s.", this.productLicense.getApplications().getKeys(), this.abbreviatedLicenseString());
        }

        private static String abbreviate(String licenseString) {
            return StringUtils.abbreviate((String)licenseString, (int)40);
        }
    }
}

