/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.license;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CachedReference;
import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Option;
import com.atlassian.jira.CachingComponent;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.application.ApplicationConfigurationHelper;
import com.atlassian.jira.auditing.AuditingManager;
import com.atlassian.jira.auditing.handlers.SystemAuditEventHandler;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.license.BuildVersionLicenseCheck;
import com.atlassian.jira.license.ConfirmEvaluationLicenseEvent;
import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.jira.license.LicenseChangedEvent;
import com.atlassian.jira.license.LicenseCheck;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.license.LicenseDetailsFactory;
import com.atlassian.jira.license.MultiLicenseStore;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.license.SIDManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

@EventComponent
public class JiraLicenseManagerImpl
implements JiraLicenseManager,
CachingComponent {
    private final SIDManager sidManager;
    private final EventPublisher eventPublisher;
    private final LicenseDetailsFactory licenseDetailsFactory;
    private final ApplicationProperties applicationProperties;
    private final MultiLicenseStore multiLicenseStore;
    private final CachedReference<CachedLicenses> cache;
    private final CopyOnWriteArrayList<Consumer<Void>> clearCacheConsumers;

    public JiraLicenseManagerImpl(SIDManager sidManager, EventPublisher eventPublisher, MultiLicenseStore multiLicenseStore, LicenseDetailsFactory licenseDetailsFactory, ApplicationProperties applicationProperties, CacheManager cacheManager) {
        this.eventPublisher = (EventPublisher)Assertions.notNull((String)"eventPublisher", (Object)eventPublisher);
        this.licenseDetailsFactory = (LicenseDetailsFactory)Assertions.notNull((String)"licenseDetailsFactory", (Object)licenseDetailsFactory);
        this.multiLicenseStore = (MultiLicenseStore)Assertions.notNull((String)"multiLicenseStore", (Object)multiLicenseStore);
        this.sidManager = (SIDManager)Assertions.notNull((String)"sidManager", (Object)sidManager);
        this.applicationProperties = (ApplicationProperties)Assertions.notNull((String)"applicationProperties", (Object)applicationProperties);
        this.cache = cacheManager.getCachedReference(JiraLicenseManager.class, "License.cache", this::loadLicenses);
        this.clearCacheConsumers = Lists.newCopyOnWriteArrayList();
    }

    public String getServerId() {
        String serverId = this.multiLicenseStore.retrieveServerId();
        if (StringUtils.isBlank((String)serverId)) {
            serverId = this.sidManager.generateSID();
            this.multiLicenseStore.storeServerId(serverId);
        }
        return serverId;
    }

    @Nonnull
    public LicenseDetails getLicense(@Nonnull String licenseString) {
        Assertions.notNull((String)"licenseString", (Object)licenseString);
        return (LicenseDetails)((CachedLicenses)this.cache.get()).lookupByLicenseString(licenseString).getOrElse(() -> this.licenseDetailsFactory.getLicense(licenseString));
    }

    @Nonnull
    public List<LicenseDetails> getLicenses() {
        return ((CachedLicenses)this.cache.get()).licenses();
    }

    @Nonnull
    public Set<ApplicationKey> getAllLicensedApplicationKeys() {
        return ((CachedLicenses)this.cache.get()).licensedKeys();
    }

    public SortedSet<String> getSupportEntitlementNumbers() {
        return ((CachedLicenses)this.cache.get()).sens();
    }

    public Option<LicenseDetails> getLicense(@Nonnull ApplicationKey application) {
        return ((CachedLicenses)this.cache.get()).lookupLicenseByKey((ApplicationKey)Assertions.notNull((String)"application", (Object)application));
    }

    public boolean isLicensed(@Nonnull ApplicationKey application) {
        return ((CachedLicenses)this.cache.get()).isLicensed((ApplicationKey)Assertions.notNull((String)"application", (Object)application));
    }

    public boolean isDecodeable(String licenseString) {
        Assertions.notBlank((String)"licenseString", (String)licenseString);
        return this.licenseDetailsFactory.isDecodeable(licenseString);
    }

    public LicenseDetails setLicense(String licenseString) {
        Assertions.notBlank((String)"licenseString", (String)licenseString);
        return this.addLicense(licenseString, true);
    }

    public LicenseDetails setLicenseNoEvent(String licenseString) {
        Assertions.notBlank((String)"licenseString", (String)licenseString);
        return this.addLicense(licenseString, false);
    }

    public void removeLicense(@Nonnull ApplicationKey application) {
        Assertions.notNull((String)"application", (Object)application);
        ArrayList licensesToKeep = Lists.newArrayList();
        ArrayList licenseDetailsToBeRemoved = Lists.newArrayList();
        for (LicenseDetails licenseDetails : this.getLicenses()) {
            if (licenseDetails.hasApplication(application)) {
                licenseDetailsToBeRemoved.add(licenseDetails);
                continue;
            }
            licensesToKeep.add(licenseDetails);
        }
        this.updateStoreLicenses(licensesToKeep, licenseDetailsToBeRemoved);
    }

    public void removeLicenses(@Nonnull Iterable<? extends LicenseDetails> licenses) {
        Assertions.containsNoNulls((String)"licenses", licenses);
        HashSet licensesToKeep = Sets.newHashSet((Iterable)this.getLicenses());
        HashSet licensesToRemove = Sets.newHashSet(licenses);
        licensesToRemove.retainAll(licensesToKeep);
        licensesToKeep.removeAll(licensesToRemove);
        this.updateStoreLicenses(licensesToKeep, licensesToRemove);
    }

    private void updateStoreLicenses(Collection<LicenseDetails> licensesToKeep, Collection<LicenseDetails> licenseDetailsToBeRemoved) {
        if (licensesToKeep.isEmpty()) {
            throw new IllegalStateException("Unable to remove license, JIRA needs to contain at least one license to be functional");
        }
        if (!licenseDetailsToBeRemoved.isEmpty()) {
            List<String> licenseStringsToKeep = licensesToKeep.stream().map(LicenseDetails::getLicenseString).collect(Collectors.toList());
            this.store(licenseStringsToKeep);
            this.resetOldBuildConfirmationConsideringGracePeriod();
            for (LicenseDetails removed : licenseDetailsToBeRemoved) {
                this.publishLicenseChangedEvent(new LicenseChangedEvent(Option.option((Object)removed), Option.none()));
            }
        }
    }

    private void publishLicenseChangedEvent(LicenseChangedEvent event) {
        ((ApplicationConfigurationHelper)ComponentAccessor.getComponent(ApplicationConfigurationHelper.class)).configureLicense(event);
        this.eventPublisher.publish((Object)event);
    }

    public boolean isLicenseSet() {
        return !((CachedLicenses)this.cache.get()).licenses().isEmpty();
    }

    public void clearAndSetLicense(String licenseString) {
        Assertions.notBlank((String)"licenseString", (String)licenseString);
        Iterable licenses = this.getLicenses();
        Option<LicenseDetails> previousAssociatedLicense = licenses.isEmpty() ? Option.none() : this.findExistingLicenseDetails(this.getLicense(licenseString));
        LicenseDetails newLicenseDetails = this.clearAndSetLicenseNoEvent(licenseString);
        this.publishLicenseChangedEvent(new LicenseChangedEvent(previousAssociatedLicense, Option.option((Object)newLicenseDetails)));
    }

    public LicenseDetails clearAndSetLicenseNoEvent(String licenseString) {
        Assertions.notBlank((String)"licenseString", (String)licenseString);
        this.verifyEncodable(licenseString);
        this.store((Iterable<String>)ImmutableList.of((Object)licenseString));
        return this.getLicense(licenseString);
    }

    @EventListener
    public void onCacheClear(ClearCacheEvent clearEvent) {
        this.clearCache();
    }

    private void verifyEncodable(String licenseString) {
        if (!this.isDecodeable(licenseString)) {
            throw new IllegalArgumentException("The licenseString is invalid and will not be stored.");
        }
    }

    private Option<LicenseDetails> findExistingLicenseDetails(@Nonnull LicenseDetails licenseDetails) {
        for (ApplicationKey licensedApplication : licenseDetails.getLicensedApplications().getKeys()) {
            Option<LicenseDetails> license = this.getLicense(licensedApplication);
            if (!license.isDefined()) continue;
            return license;
        }
        return Option.none();
    }

    private LicenseDetails addLicense(String licenseString, boolean fireEvent) {
        this.verifyEncodable(licenseString);
        LicenseDetails licenseDetails = this.getLicense(licenseString);
        LicenseChangedEvent event = new LicenseChangedEvent(this.findExistingLicenseDetails(licenseDetails), Option.option((Object)licenseDetails));
        this.replaceLicense(licenseString);
        this.resetOldBuildConfirmationWithoutConsideringGracePeriod();
        if (fireEvent) {
            this.publishLicenseChangedEvent(event);
        } else {
            ((AuditingManager)Assertions.notNull((String)"auditingManager", (Object)ComponentAccessor.getComponent(AuditingManager.class))).store(((SystemAuditEventHandler)Assertions.notNull((String)"systemAuditEventHandler", (Object)ComponentAccessor.getComponent(SystemAuditEventHandler.class))).onLicenseChangedEvent(event));
        }
        return licenseDetails;
    }

    private void resetOldBuildConfirmationConsideringGracePeriod() {
        this.resetOldBuildConfirmationIfNecessary(check -> check.evaluate().isPass());
    }

    private void resetOldBuildConfirmationWithoutConsideringGracePeriod() {
        this.resetOldBuildConfirmationIfNecessary(check -> check.evaluateWithoutGracePeriod().isPass());
    }

    private void resetOldBuildConfirmationIfNecessary(Function<BuildVersionLicenseCheck, Boolean> check) {
        BuildVersionLicenseCheck buildVersionLicenseCheck;
        if (this.hasLicenseTooOldForBuildConfirmationBeenDone() && check.apply(buildVersionLicenseCheck = (BuildVersionLicenseCheck)ComponentAccessor.getComponent(BuildVersionLicenseCheck.class)).booleanValue()) {
            this.multiLicenseStore.resetOldBuildConfirmation();
        }
    }

    private void replaceLicense(String licenseString) {
        LicenseDetails license = this.getLicense(licenseString);
        Set newLicensedApplications = license.getLicensedApplications().getKeys();
        List withoutNewRoles = (List)this.getLicenses().stream().filter(details -> Collections.disjoint(details.getLicensedApplications().getKeys(), newLicensedApplications)).map(LicenseDetails::getLicenseString).collect(CollectorsUtil.toImmutableList());
        this.store(Iterables.concat((Iterable)ImmutableList.of((Object)licenseString), (Iterable)withoutNewRoles));
    }

    public void confirmProceedUnderEvaluationTerms(String userName) {
        BuildVersionLicenseCheck buildVersionLicenseCheck = (BuildVersionLicenseCheck)ComponentAccessor.getComponent(BuildVersionLicenseCheck.class);
        LicenseCheck.Result result = buildVersionLicenseCheck.evaluateWithoutGracePeriod();
        List<LicenseDetails> expiredLicenses = result.getFailedLicenses();
        this.multiLicenseStore.confirmProceedUnderEvaluationTerms(userName);
        this.eventPublisher.publish((Object)new ConfirmEvaluationLicenseEvent(userName, expiredLicenses));
    }

    public boolean hasLicenseTooOldForBuildConfirmationBeenDone() {
        return this.applicationProperties.getOption("jira.install.oldlicense.confirmed");
    }

    public void subscribeToClearCache(@Nonnull Consumer<Void> consumer) {
        this.clearCacheConsumers.addIfAbsent(consumer);
    }

    public void unSubscribeFromClearCache(@Nonnull Consumer<Void> consumer) {
        this.clearCacheConsumers.remove(consumer);
    }

    @Override
    public void clearCache() {
        this.cache.reset();
        this.clearCacheConsumers.stream().forEach(consumer -> consumer.accept(null));
    }

    private void store(Iterable<String> licenseString) {
        this.multiLicenseStore.store(licenseString);
        this.clearCache();
    }

    private CachedLicenses loadLicenses() {
        return new CachedLicenses(Iterables.transform(this.multiLicenseStore.retrieve(), this.licenseDetailsFactory::getLicense));
    }

    private static class CachedLicenses {
        private final ImmutableSortedSet<String> sens;
        private final ImmutableList<LicenseDetails> licenses;
        private final ImmutableMap<ApplicationKey, LicenseDetails> licensesByApplicationKey;
        private final ImmutableMap<String, LicenseDetails> licensesByLicenseString;

        private CachedLicenses(Iterable<? extends LicenseDetails> details) {
            ImmutableSortedSet.Builder sens = ImmutableSortedSet.orderedBy(Comparator.naturalOrder());
            ImmutableList.Builder licenses = ImmutableList.builder();
            ImmutableMap.Builder licensesByApplicationKey = ImmutableMap.builder();
            ImmutableMap.Builder licensesByLicenseString = ImmutableMap.builder();
            for (LicenseDetails licenseDetails : details) {
                if (licenseDetails == null) continue;
                licenses.add((Object)licenseDetails);
                licensesByLicenseString.put((Object)licenseDetails.getLicenseString(), (Object)licenseDetails);
                for (ApplicationKey applicationKey : licenseDetails.getLicensedApplications().getKeys()) {
                    licensesByApplicationKey.put((Object)applicationKey, (Object)licenseDetails);
                }
                String sen = StringUtils.stripToNull((String)licenseDetails.getSupportEntitlementNumber());
                if (sen == null) continue;
                sens.add((Object)sen);
            }
            this.sens = sens.build();
            this.licenses = licenses.build();
            this.licensesByApplicationKey = licensesByApplicationKey.build();
            this.licensesByLicenseString = licensesByLicenseString.build();
        }

        private SortedSet<String> sens() {
            return this.sens;
        }

        private List<LicenseDetails> licenses() {
            return this.licenses;
        }

        private Set<ApplicationKey> licensedKeys() {
            return this.licensesByApplicationKey.keySet();
        }

        private Option<LicenseDetails> lookupLicenseByKey(ApplicationKey key) {
            return Option.option((Object)this.licensesByApplicationKey.get((Object)key));
        }

        private boolean isLicensed(ApplicationKey key) {
            return this.licensesByApplicationKey.containsKey((Object)key);
        }

        private Option<LicenseDetails> lookupByLicenseString(String license) {
            return Option.option((Object)this.licensesByLicenseString.get((Object)license));
        }
    }
}

