/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.values;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class GroupValuesGenerator
implements ClauseValuesGenerator {
    private final GroupManager groupManager;

    public GroupValuesGenerator(GroupManager groupManager) {
        this.groupManager = groupManager;
    }

    public ClauseValuesGenerator.Results getPossibleValues(ApplicationUser searcher, String jqlClauseName, String valuePrefix, int maxNumResults) {
        Collection<Group> groups = this.getAllGroups();
        ArrayList groupValues = Lists.newArrayListWithCapacity((int)groups.size());
        for (Group group : groups) {
            if (groupValues.size() == maxNumResults) break;
            String lowerCaseGroupName = group.getName().toLowerCase();
            if (!StringUtils.isBlank((String)valuePrefix) && !lowerCaseGroupName.startsWith(valuePrefix.toLowerCase())) continue;
            groupValues.add(new ClauseValuesGenerator.Result(group.getName()));
        }
        return new ClauseValuesGenerator.Results((List)groupValues);
    }

    protected Collection<Group> getAllGroups() {
        return this.groupManager.getAllGroups();
    }
}

