/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.resolver.ProjectIndexInfoResolver;
import com.atlassian.jira.jql.validator.ValuesExistValidator;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.List;

class ProjectValuesExistValidator
extends ValuesExistValidator {
    private final ProjectIndexInfoResolver projectIndexInfoResolver;
    private final PermissionManager permissionManager;
    private final ProjectManager projectManager;

    ProjectValuesExistValidator(JqlOperandResolver operandResolver, ProjectIndexInfoResolver projectIndexInfoResolver, PermissionManager permissionManager, ProjectManager projectManager, I18nHelper.BeanFactory beanFactory) {
        super(operandResolver, beanFactory);
        this.projectIndexInfoResolver = (ProjectIndexInfoResolver)Assertions.notNull((String)"projectIndexInfoResolver", (Object)projectIndexInfoResolver);
        this.permissionManager = (PermissionManager)Assertions.notNull((String)"permissionManager", (Object)permissionManager);
        this.projectManager = (ProjectManager)Assertions.notNull((String)"projectManager", (Object)projectManager);
    }

    boolean stringValueExists(ApplicationUser searcher, String value) {
        List<String> ids = this.projectIndexInfoResolver.getIndexedValues(value);
        return this.projectExists(searcher, ids);
    }

    boolean longValueExist(ApplicationUser searcher, Long value) {
        List<String> ids = this.projectIndexInfoResolver.getIndexedValues(value);
        return this.projectExists(searcher, ids);
    }

    boolean projectExists(ApplicationUser searcher, List<String> ids) {
        for (String sid : ids) {
            Project project;
            Long id = this.convertToLong(sid);
            if (id == null || (project = this.projectManager.getProjectObj(id)) == null || !this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, project, searcher)) continue;
            return true;
        }
        return false;
    }

    private Long convertToLong(String str) {
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

