/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.resolver;

import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;

@InjectableComponent
public class IssueSecurityLevelResolver {
    private final IssueSecurityLevelManager issueSecurityLevelManager;

    public IssueSecurityLevelResolver(IssueSecurityLevelManager issueSecurityLevelManager) {
        this.issueSecurityLevelManager = (IssueSecurityLevelManager)Assertions.notNull((String)"issueSecurityLevelManager", (Object)issueSecurityLevelManager);
    }

    public List<IssueSecurityLevel> getAllSecurityLevels(ApplicationUser searcher) {
        return new ArrayList<IssueSecurityLevel>(this.issueSecurityLevelManager.getAllSecurityLevelsForUser(searcher));
    }

    public List<IssueSecurityLevel> getIssueSecurityLevels(ApplicationUser searcher, QueryLiteral rawValue) {
        return this.getIssueSecurityLevels(searcher, Collections.singletonList(rawValue));
    }

    public List<IssueSecurityLevel> getIssueSecurityLevels(ApplicationUser searcher, List<QueryLiteral> rawValues) {
        return this._getIssueSecurityLevels(searcher, false, rawValues);
    }

    public List<IssueSecurityLevel> getIssueSecurityLevelsOverrideSecurity(List<QueryLiteral> rawValues) {
        return this._getIssueSecurityLevels(null, true, rawValues);
    }

    private List<IssueSecurityLevel> _getIssueSecurityLevels(ApplicationUser searcher, boolean overrideSecurity, List<QueryLiteral> rawValues) {
        Assertions.notNull((String)"rawValues", rawValues);
        ArrayList matchingLevels = Lists.newArrayListWithCapacity((int)rawValues.size());
        for (QueryLiteral rawValue : rawValues) {
            Assertions.notNull((String)"rawValue", (Object)rawValue);
            if (rawValue.getStringValue() != null) {
                matchingLevels.addAll(this.getIssueSecurityLevelsForString(searcher, overrideSecurity, rawValue.getStringValue()));
                continue;
            }
            if (rawValue.getLongValue() != null) {
                matchingLevels.addAll(this.getIssueSecurityLevelsForLong(searcher, overrideSecurity, rawValue.getLongValue()));
                continue;
            }
            if (!rawValue.isEmpty()) continue;
            matchingLevels.add(null);
        }
        return matchingLevels;
    }

    private Collection<IssueSecurityLevel> getIssueSecurityLevelsForString(ApplicationUser searcher, boolean overrideSecurity, String rawValue) {
        IssueSecurityLevel securityLevel;
        Long valueAsLong;
        Collection<IssueSecurityLevel> levels = this.getIssueSecurityLevelsByName(searcher, overrideSecurity, rawValue);
        if (levels == null) {
            levels = new LinkedHashSet<IssueSecurityLevel>();
        }
        if (levels.isEmpty() && (valueAsLong = this.getValueAsLong(rawValue)) != null && (securityLevel = this.getIssueSecurityLevelById(searcher, overrideSecurity, valueAsLong)) != null) {
            levels.add(securityLevel);
        }
        return levels;
    }

    private List<IssueSecurityLevel> getIssueSecurityLevelsForLong(ApplicationUser searcher, boolean overrideSecurity, Long rawValue) {
        ArrayList<IssueSecurityLevel> levels = new ArrayList<IssueSecurityLevel>();
        IssueSecurityLevel level = this.getIssueSecurityLevelById(searcher, overrideSecurity, rawValue);
        if (level != null) {
            levels.add(level);
        } else {
            Collection<IssueSecurityLevel> securityLevelsByName = this.getIssueSecurityLevelsByName(searcher, overrideSecurity, rawValue.toString());
            if (securityLevelsByName != null) {
                levels.addAll(securityLevelsByName);
            }
        }
        return levels;
    }

    IssueSecurityLevel getIssueSecurityLevelById(ApplicationUser searcher, boolean overrideSecurity, Long valueAsLong) {
        Collection usersSecurityLevels = overrideSecurity ? this.issueSecurityLevelManager.getAllIssueSecurityLevels() : this.issueSecurityLevelManager.getAllSecurityLevelsForUser(searcher);
        for (IssueSecurityLevel level : usersSecurityLevels) {
            if (!valueAsLong.equals(level.getId())) continue;
            return level;
        }
        return null;
    }

    Collection<IssueSecurityLevel> getIssueSecurityLevelsByName(ApplicationUser searcher, boolean overrideSecurity, String nameValue) {
        return overrideSecurity ? this.issueSecurityLevelManager.getIssueSecurityLevelsByName(nameValue) : this.issueSecurityLevelManager.getSecurityLevelsForUserByName(searcher, nameValue);
    }

    private Long getValueAsLong(String singleValueOperand) {
        try {
            return new Long(singleValueOperand);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

