/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.issue.search.SearchProviderFactory;
import com.atlassian.jira.issue.search.filters.IssueIdFilter;
import com.atlassian.jira.jql.query.IssueIdCollector;
import java.io.IOException;
import java.util.Set;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueIdFilterQueryFactory {
    private static final Logger log = LoggerFactory.getLogger(IssueIdFilterQueryFactory.class);
    private final SearchProviderFactory searchProviderFactory;

    public IssueIdFilterQueryFactory(SearchProviderFactory searchProviderFactory) {
        this.searchProviderFactory = searchProviderFactory;
    }

    public Query createIssueIdFilterQuery(Query indexQuery, String indexName) {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Searching the " + indexName + " index using the query: " + indexQuery.toString());
            }
            IndexSearcher searcher = this.searchProviderFactory.getSearcher(indexName);
            IssueIdCollector collector = new IssueIdCollector(searcher.getIndexReader());
            searcher.search(indexQuery, (Collector)collector);
            Set<String> issueIds = collector.getIssueIds();
            return new ConstantScoreQuery((Filter)new IssueIdFilter(issueIds));
        }
        catch (IOException e) {
            log.error("Unable to search the " + indexName + " index.", (Throwable)e);
            return new BooleanQuery();
        }
    }
}

