/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.fugue.Option;
import com.atlassian.jira.issue.search.constants.SimpleFieldSearchConstants;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryRegistry;
import com.atlassian.jira.jql.query.WorklogClauseQueryFactory;
import com.atlassian.jira.jql.query.WorklogQueryRegistry;
import com.atlassian.query.clause.TerminalClause;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public final class DefaultWorklogQueryRegistry
implements WorklogQueryRegistry {
    private final List<SimpleFieldSearchConstants> worklogConstants = ImmutableList.of((Object)SystemSearchConstants.forWorklogAuthor(), (Object)SystemSearchConstants.forWorklogDate(), (Object)SystemSearchConstants.forWorklogComment());
    private final QueryRegistry queryRegistry;
    private final Set<String> worklogClauses;

    public DefaultWorklogQueryRegistry(QueryRegistry queryRegistry) {
        this.queryRegistry = queryRegistry;
        this.worklogClauses = this.resolveClauseHandlers();
    }

    private Set<String> resolveClauseHandlers() {
        return ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)Iterables.transform(this.worklogConstants, (Function)new Function<SimpleFieldSearchConstants, Iterable<String>>(){

            public Iterable<String> apply(SimpleFieldSearchConstants input) {
                return input.getJqlClauseNames().getJqlFieldNames();
            }
        })));
    }

    @Override
    public Option<WorklogClauseQueryFactory> getClauseQueryFactory(QueryCreationContext context, TerminalClause clause) {
        ClauseQueryFactory factory;
        Collection<ClauseQueryFactory> factories = this.queryRegistry.getClauseQueryFactory(context, clause);
        if (this.worklogClauses.contains(clause.getName()) && factories.size() == 1 && (factory = factories.iterator().next()) instanceof WorklogClauseQueryFactory) {
            return Option.some((Object)((WorklogClauseQueryFactory)factory));
        }
        return Option.none();
    }
}

