/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.query.WatcherClauseQueryFactory;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operator.Operator;
import javax.annotation.Nonnull;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InjectableComponent
public class AttachmentClauseQueryFactory
implements ClauseQueryFactory {
    private static final Logger log = LoggerFactory.getLogger(WatcherClauseQueryFactory.class);

    @Nonnull
    public QueryFactoryResult getQuery(@Nonnull QueryCreationContext queryCreationContext, @Nonnull TerminalClause terminalClause) {
        if (SystemSearchConstants.forAttachments().getSupportedOperators().contains(terminalClause.getOperator())) {
            return new QueryFactoryResult((Query)new TermQuery(new Term("issue_has_attachment", this.getTermText(terminalClause.getOperator()))));
        }
        log.debug("Attempt to search attachments when attachments are disabled.");
        return QueryFactoryResult.createFalseResult();
    }

    private String getTermText(Operator operator) {
        return String.valueOf(operator != Operator.IS);
    }
}

