/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.permission;

import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.permission.AbstractLiteralSanitisingVisitor;
import com.atlassian.jira.jql.permission.ClauseSanitiser;
import com.atlassian.jira.jql.permission.IssueLiteralSanitiser;
import com.atlassian.jira.jql.permission.LiteralSanitiser;
import com.atlassian.jira.jql.util.JqlIssueSupport;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.OrClause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.operand.MultiValueOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operand.OperandVisitor;
import com.atlassian.query.operand.SingleValueOperand;
import com.atlassian.query.operator.Operator;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueClauseValueSanitiser
implements ClauseSanitiser {
    private static final Logger log = LoggerFactory.getLogger(IssueClauseValueSanitiser.class);
    private final PermissionManager permissionManager;
    private final JqlOperandResolver jqlOperandResolver;
    private final JqlIssueSupport jqlIssueSupport;

    public IssueClauseValueSanitiser(PermissionManager permissionManager, JqlOperandResolver jqlOperandResolver, JqlIssueSupport jqlIssueSupport) {
        this.permissionManager = (PermissionManager)Assertions.notNull((String)"permissionManager", (Object)permissionManager);
        this.jqlOperandResolver = (JqlOperandResolver)Assertions.notNull((String)"jqlOperandResolver", (Object)jqlOperandResolver);
        this.jqlIssueSupport = (JqlIssueSupport)Assertions.notNull((String)"jqlIssueSupport", (Object)jqlIssueSupport);
    }

    public Clause sanitise(ApplicationUser user, TerminalClause clause) {
        Operand sanitisedOperand;
        String clauseName = clause.getName();
        Operator operator = clause.getOperator();
        IssueOperandSanitisingVisitor visitor = this.createOperandVisitor(user, clause);
        Operand originalOperand = clause.getOperand();
        if (originalOperand.equals(sanitisedOperand = (Operand)originalOperand.accept((OperandVisitor)visitor))) {
            return clause;
        }
        if (originalOperand.getClass().equals(sanitisedOperand.getClass())) {
            return new TerminalClauseImpl(clauseName, operator, sanitisedOperand);
        }
        if (originalOperand instanceof SingleValueOperand && sanitisedOperand instanceof MultiValueOperand) {
            if (OperatorClasses.POSITIVE_EQUALITY_OPERATORS.contains(operator)) {
                return new TerminalClauseImpl(clauseName, Operator.IN, sanitisedOperand);
            }
            if (OperatorClasses.NEGATIVE_EQUALITY_OPERATORS.contains(operator)) {
                return new TerminalClauseImpl(clauseName, Operator.NOT_IN, sanitisedOperand);
            }
            if (OperatorClasses.RELATIONAL_ONLY_OPERATORS.contains(operator)) {
                MultiValueOperand multiOperand = (MultiValueOperand)sanitisedOperand;
                ArrayList clauses = Lists.newArrayListWithCapacity((int)multiOperand.getValues().size());
                for (Operand operand : multiOperand.getValues()) {
                    clauses.add(new TerminalClauseImpl(clauseName, operator, operand));
                }
                return new OrClause((Collection)clauses);
            }
        }
        log.debug(String.format("Could not figure out how to reconcile original operand '%s' and sanitised operand '%s'", originalOperand.getDisplayString(), sanitisedOperand.getDisplayString()));
        return clause;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueClauseValueSanitiser that = (IssueClauseValueSanitiser)o;
        if (this.jqlIssueSupport != null ? !this.jqlIssueSupport.equals(that.jqlIssueSupport) : that.jqlIssueSupport != null) {
            return false;
        }
        if (this.jqlOperandResolver != null ? !this.jqlOperandResolver.equals(that.jqlOperandResolver) : that.jqlOperandResolver != null) {
            return false;
        }
        return !(this.permissionManager != null ? !this.permissionManager.equals(that.permissionManager) : that.permissionManager != null);
    }

    public int hashCode() {
        int result = this.permissionManager != null ? this.permissionManager.hashCode() : 0;
        result = 31 * result + (this.jqlOperandResolver != null ? this.jqlOperandResolver.hashCode() : 0);
        result = 31 * result + (this.jqlIssueSupport != null ? this.jqlIssueSupport.hashCode() : 0);
        return result;
    }

    IssueOperandSanitisingVisitor createOperandVisitor(ApplicationUser user, TerminalClause terminalClause) {
        return new IssueOperandSanitisingVisitor(this.jqlOperandResolver, this.permissionManager, user, terminalClause, this.jqlIssueSupport);
    }

    static class IssueOperandSanitisingVisitor
    extends AbstractLiteralSanitisingVisitor {
        private final PermissionManager permissionManager;
        private final ApplicationUser user;
        private final JqlIssueSupport jqlIssueSupport;

        IssueOperandSanitisingVisitor(JqlOperandResolver jqlOperandResolver, PermissionManager permissionManager, ApplicationUser user, TerminalClause terminalClause, JqlIssueSupport jqlIssueSupport) {
            super(jqlOperandResolver, user, terminalClause);
            this.permissionManager = permissionManager;
            this.user = user;
            this.jqlIssueSupport = jqlIssueSupport;
        }

        @Override
        protected LiteralSanitiser createLiteralSanitiser() {
            return new IssueLiteralSanitiser(this.permissionManager, this.jqlIssueSupport, this.user);
        }
    }
}

